
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "containerID",
    "exitCode",
    "finishedAt",
    "message",
    "reason",
    "signal",
    "startedAt"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class ContainerStateTerminated {

    /**
     * container's ID in the format 'docker://<container_id>'
     * 
     */
    @JsonProperty("containerID")
    private String containerID;
    /**
     * exit status from the last termination of the container
     * 
     */
    @JsonProperty("exitCode")
    private Integer exitCode;
    /**
     * time at which the container last terminated
     * 
     */
    @JsonProperty("finishedAt")
    private String finishedAt;
    /**
     * message regarding the last termination of the container
     * 
     */
    @JsonProperty("message")
    private String message;
    /**
     * (brief) reason from the last termination of the container
     * 
     */
    @JsonProperty("reason")
    private String reason;
    /**
     * signal from the last termination of the container
     * 
     */
    @JsonProperty("signal")
    private Integer signal;
    /**
     * time at which previous execution of the container started
     * 
     */
    @JsonProperty("startedAt")
    private String startedAt;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ContainerStateTerminated() {
    }

    /**
     * 
     * @param message
     * @param reason
     * @param finishedAt
     * @param startedAt
     * @param signal
     * @param exitCode
     * @param containerID
     */
    public ContainerStateTerminated(String containerID, Integer exitCode, String finishedAt, String message, String reason, Integer signal, String startedAt) {
        this.containerID = containerID;
        this.exitCode = exitCode;
        this.finishedAt = finishedAt;
        this.message = message;
        this.reason = reason;
        this.signal = signal;
        this.startedAt = startedAt;
    }

    /**
     * container's ID in the format 'docker://<container_id>'
     * 
     * @return
     *     The containerID
     */
    @JsonProperty("containerID")
    public String getContainerID() {
        return containerID;
    }

    /**
     * container's ID in the format 'docker://<container_id>'
     * 
     * @param containerID
     *     The containerID
     */
    @JsonProperty("containerID")
    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    /**
     * exit status from the last termination of the container
     * 
     * @return
     *     The exitCode
     */
    @JsonProperty("exitCode")
    public Integer getExitCode() {
        return exitCode;
    }

    /**
     * exit status from the last termination of the container
     * 
     * @param exitCode
     *     The exitCode
     */
    @JsonProperty("exitCode")
    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    /**
     * time at which the container last terminated
     * 
     * @return
     *     The finishedAt
     */
    @JsonProperty("finishedAt")
    public String getFinishedAt() {
        return finishedAt;
    }

    /**
     * time at which the container last terminated
     * 
     * @param finishedAt
     *     The finishedAt
     */
    @JsonProperty("finishedAt")
    public void setFinishedAt(String finishedAt) {
        this.finishedAt = finishedAt;
    }

    /**
     * message regarding the last termination of the container
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * message regarding the last termination of the container
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * (brief) reason from the last termination of the container
     * 
     * @return
     *     The reason
     */
    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    /**
     * (brief) reason from the last termination of the container
     * 
     * @param reason
     *     The reason
     */
    @JsonProperty("reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * signal from the last termination of the container
     * 
     * @return
     *     The signal
     */
    @JsonProperty("signal")
    public Integer getSignal() {
        return signal;
    }

    /**
     * signal from the last termination of the container
     * 
     * @param signal
     *     The signal
     */
    @JsonProperty("signal")
    public void setSignal(Integer signal) {
        this.signal = signal;
    }

    /**
     * time at which previous execution of the container started
     * 
     * @return
     *     The startedAt
     */
    @JsonProperty("startedAt")
    public String getStartedAt() {
        return startedAt;
    }

    /**
     * time at which previous execution of the container started
     * 
     * @param startedAt
     *     The startedAt
     */
    @JsonProperty("startedAt")
    public void setStartedAt(String startedAt) {
        this.startedAt = startedAt;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
