package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class PodTemplateSpecBuilder extends PodTemplateSpecFluent<PodTemplateSpecBuilder> implements VisitableBuilder<PodTemplateSpec,PodTemplateSpecBuilder>{

     PodTemplateSpecFluent<?> fluent;
public PodTemplateSpecBuilder(){
    this(new PodTemplateSpec());
}
public PodTemplateSpecBuilder( PodTemplateSpecFluent<?> fluent ){
    this(fluent, new PodTemplateSpec());
}
public PodTemplateSpecBuilder( PodTemplateSpecFluent<?> fluent , PodTemplateSpec instance ){
    this.fluent = fluent; fluent.withMetadata(instance.getMetadata()); fluent.withSpec(instance.getSpec()); 
}
public PodTemplateSpecBuilder( PodTemplateSpec instance ){
    this.fluent = this; this.withMetadata(instance.getMetadata()); this.withSpec(instance.getSpec()); 
}

public EditablePodTemplateSpec build(){
    EditablePodTemplateSpec buildable = new EditablePodTemplateSpec(fluent.getMetadata(),fluent.getSpec());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    