
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "cancelled",
    "completionTimestamp",
    "config",
    "duration",
    "message",
    "phase",
    "startTimestamp"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class BuildStatus {

    /**
     * describes if a canceling event was triggered for the build
     * 
     */
    @JsonProperty("cancelled")
    private Boolean cancelled;
    /**
     * server time when the pod running this build stopped running
     * 
     */
    @JsonProperty("completionTimestamp")
    private String completionTimestamp;
    /**
     * 
     * 
     */
    @JsonProperty("config")
    @Valid
    private ObjectReference config;
    /**
     * amount of time the build has been running
     * 
     */
    @JsonProperty("duration")
    private Long duration;
    /**
     * human-readable message indicating details about why the build has this status
     * 
     */
    @JsonProperty("message")
    private String message;
    /**
     * observed point in the build lifecycle
     * 
     */
    @JsonProperty("phase")
    private String phase;
    /**
     * server time when this build started running in a pod
     * 
     */
    @JsonProperty("startTimestamp")
    private String startTimestamp;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BuildStatus() {
    }

    /**
     * 
     * @param message
     * @param duration
     * @param completionTimestamp
     * @param startTimestamp
     * @param cancelled
     * @param config
     * @param phase
     */
    public BuildStatus(Boolean cancelled, String completionTimestamp, ObjectReference config, Long duration, String message, String phase, String startTimestamp) {
        this.cancelled = cancelled;
        this.completionTimestamp = completionTimestamp;
        this.config = config;
        this.duration = duration;
        this.message = message;
        this.phase = phase;
        this.startTimestamp = startTimestamp;
    }

    /**
     * describes if a canceling event was triggered for the build
     * 
     * @return
     *     The cancelled
     */
    @JsonProperty("cancelled")
    public Boolean getCancelled() {
        return cancelled;
    }

    /**
     * describes if a canceling event was triggered for the build
     * 
     * @param cancelled
     *     The cancelled
     */
    @JsonProperty("cancelled")
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    /**
     * server time when the pod running this build stopped running
     * 
     * @return
     *     The completionTimestamp
     */
    @JsonProperty("completionTimestamp")
    public String getCompletionTimestamp() {
        return completionTimestamp;
    }

    /**
     * server time when the pod running this build stopped running
     * 
     * @param completionTimestamp
     *     The completionTimestamp
     */
    @JsonProperty("completionTimestamp")
    public void setCompletionTimestamp(String completionTimestamp) {
        this.completionTimestamp = completionTimestamp;
    }

    /**
     * 
     * 
     * @return
     *     The config
     */
    @JsonProperty("config")
    public ObjectReference getConfig() {
        return config;
    }

    /**
     * 
     * 
     * @param config
     *     The config
     */
    @JsonProperty("config")
    public void setConfig(ObjectReference config) {
        this.config = config;
    }

    /**
     * amount of time the build has been running
     * 
     * @return
     *     The duration
     */
    @JsonProperty("duration")
    public Long getDuration() {
        return duration;
    }

    /**
     * amount of time the build has been running
     * 
     * @param duration
     *     The duration
     */
    @JsonProperty("duration")
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    /**
     * human-readable message indicating details about why the build has this status
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * human-readable message indicating details about why the build has this status
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * observed point in the build lifecycle
     * 
     * @return
     *     The phase
     */
    @JsonProperty("phase")
    public String getPhase() {
        return phase;
    }

    /**
     * observed point in the build lifecycle
     * 
     * @param phase
     *     The phase
     */
    @JsonProperty("phase")
    public void setPhase(String phase) {
        this.phase = phase;
    }

    /**
     * server time when this build started running in a pod
     * 
     * @return
     *     The startTimestamp
     */
    @JsonProperty("startTimestamp")
    public String getStartTimestamp() {
        return startTimestamp;
    }

    /**
     * server time when this build started running in a pod
     * 
     * @param startTimestamp
     *     The startTimestamp
     */
    @JsonProperty("startTimestamp")
    public void setStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
