
package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "automatic",
    "containerNames",
    "from",
    "lastTriggeredImage"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class DeploymentTriggerImageChangeParams {

    /**
     * whether detection of a new tag value should trigger a deployment
     * 
     */
    @JsonProperty("automatic")
    private Boolean automatic;
    /**
     * restricts tag updates to a set of container names in the pod
     * 
     */
    @JsonProperty("containerNames")
    @Valid
    private List<String> containerNames = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("from")
    @Valid
    private ObjectReference from;
    /**
     * the last image to be triggered
     * 
     */
    @JsonProperty("lastTriggeredImage")
    private String lastTriggeredImage;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public DeploymentTriggerImageChangeParams() {
    }

    /**
     * 
     * @param automatic
     * @param from
     * @param containerNames
     * @param lastTriggeredImage
     */
    public DeploymentTriggerImageChangeParams(Boolean automatic, List<String> containerNames, ObjectReference from, String lastTriggeredImage) {
        this.automatic = automatic;
        this.containerNames = containerNames;
        this.from = from;
        this.lastTriggeredImage = lastTriggeredImage;
    }

    /**
     * whether detection of a new tag value should trigger a deployment
     * 
     * @return
     *     The automatic
     */
    @JsonProperty("automatic")
    public Boolean getAutomatic() {
        return automatic;
    }

    /**
     * whether detection of a new tag value should trigger a deployment
     * 
     * @param automatic
     *     The automatic
     */
    @JsonProperty("automatic")
    public void setAutomatic(Boolean automatic) {
        this.automatic = automatic;
    }

    /**
     * restricts tag updates to a set of container names in the pod
     * 
     * @return
     *     The containerNames
     */
    @JsonProperty("containerNames")
    public List<String> getContainerNames() {
        return containerNames;
    }

    /**
     * restricts tag updates to a set of container names in the pod
     * 
     * @param containerNames
     *     The containerNames
     */
    @JsonProperty("containerNames")
    public void setContainerNames(List<String> containerNames) {
        this.containerNames = containerNames;
    }

    /**
     * 
     * 
     * @return
     *     The from
     */
    @JsonProperty("from")
    public ObjectReference getFrom() {
        return from;
    }

    /**
     * 
     * 
     * @param from
     *     The from
     */
    @JsonProperty("from")
    public void setFrom(ObjectReference from) {
        this.from = from;
    }

    /**
     * the last image to be triggered
     * 
     * @return
     *     The lastTriggeredImage
     */
    @JsonProperty("lastTriggeredImage")
    public String getLastTriggeredImage() {
        return lastTriggeredImage;
    }

    /**
     * the last image to be triggered
     * 
     * @param lastTriggeredImage
     *     The lastTriggeredImage
     */
    @JsonProperty("lastTriggeredImage")
    public void setLastTriggeredImage(String lastTriggeredImage) {
        this.lastTriggeredImage = lastTriggeredImage;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
