package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ImageStreamSpecBuilder extends ImageStreamSpecFluent<ImageStreamSpecBuilder> implements VisitableBuilder<ImageStreamSpec,ImageStreamSpecBuilder>{

     ImageStreamSpecFluent<?> fluent;
public ImageStreamSpecBuilder(){
    this(new ImageStreamSpec());
}
public ImageStreamSpecBuilder( ImageStreamSpecFluent<?> fluent ){
    this(fluent, new ImageStreamSpec());
}
public ImageStreamSpecBuilder( ImageStreamSpecFluent<?> fluent , ImageStreamSpec instance ){
    this.fluent = fluent; fluent.withDockerImageRepository(instance.getDockerImageRepository()); fluent.withTags(instance.getTags()); 
}
public ImageStreamSpecBuilder( ImageStreamSpec instance ){
    this.fluent = this; this.withDockerImageRepository(instance.getDockerImageRepository()); this.withTags(instance.getTags()); 
}

public EditableImageStreamSpec build(){
    EditableImageStreamSpec buildable = new EditableImageStreamSpec(fluent.getDockerImageRepository(),fluent.getTags());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    