package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public class RouteFluent<T extends RouteFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Route.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<RouteSpec, ?> spec;     VisitableBuilder<RouteStatus, ?> status;     Map<String, Object> additionalProperties = new HashMap();

    public Route.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Route.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public RouteSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( RouteSpec spec){
    if (spec!=null){ this.spec= new RouteSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNested<T>();
    }
    public SpecNested<T> withNewSpecLike( RouteSpec item){
    return new SpecNested<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public RouteStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public T withStatus( RouteStatus status){
    if (status!=null){ this.status= new RouteStatusBuilder(status); _visitables.add(this.status);} return (T) this;
    }
    public StatusNested<T> withNewStatus(){
    return new StatusNested<T>();
    }
    public StatusNested<T> withNewStatusLike( RouteStatus item){
    return new StatusNested<T>(item);
    }
    public StatusNested<T> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) RouteFluent.this.withMetadata(builder.build());
        }
    
}
    public class SpecNested<N> extends RouteSpecFluent<SpecNested<N>> implements Nested<N>{

        private final RouteSpecBuilder builder;
    
             SpecNested (){
        this.builder = new RouteSpecBuilder(this);
        }
             SpecNested ( RouteSpec item){
        this.builder = new RouteSpecBuilder(this, item);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) RouteFluent.this.withSpec(builder.build());
        }
    
}
    public class StatusNested<N> extends RouteStatusFluent<StatusNested<N>> implements Nested<N>{

        private final RouteStatusBuilder builder;
    
             StatusNested (){
        this.builder = new RouteStatusBuilder(this);
        }
             StatusNested ( RouteStatus item){
        this.builder = new RouteStatusBuilder(this, item);
        }
    
            public N endStatus(){
            return and();
        }
            public N and(){
            return (N) RouteFluent.this.withStatus(builder.build());
        }
    
}


}
