/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableGlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GlusterfsVolumeSourceBuilder
extends GlusterfsVolumeSourceFluent<GlusterfsVolumeSourceBuilder>
implements VisitableBuilder<GlusterfsVolumeSource, GlusterfsVolumeSourceBuilder> {
    GlusterfsVolumeSourceFluent<?> fluent;

    public GlusterfsVolumeSourceBuilder() {
        this(new GlusterfsVolumeSource());
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent) {
        this(fluent, new GlusterfsVolumeSource());
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent, GlusterfsVolumeSource instance) {
        this.fluent = fluent;
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withPath(instance.getPath());
        fluent.withReadOnly(instance.getReadOnly());
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSource instance) {
        this.fluent = this;
        this.withEndpoints(instance.getEndpoints());
        this.withPath(instance.getPath());
        this.withReadOnly(instance.getReadOnly());
    }

    @Override
    public EditableGlusterfsVolumeSource build() {
        EditableGlusterfsVolumeSource buildable = new EditableGlusterfsVolumeSource(this.fluent.getEndpoints(), this.fluent.getPath(), this.fluent.isReadOnly());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

