/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceSpecFluent<T extends ServiceSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    String clusterIP;
    List<String> deprecatedPublicIPs = new ArrayList<String>();
    List<VisitableBuilder<ServicePort, ?>> ports = new ArrayList();
    Map<String, String> selector = new HashMap<String, String>();
    String sessionAffinity;
    String type;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public String getClusterIP() {
        return this.clusterIP;
    }

    public T withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (T)this;
    }

    public T addToDeprecatedPublicIPs(String ... items) {
        for (String item : items) {
            this.deprecatedPublicIPs.add(item);
        }
        return (T)this;
    }

    public List<String> getDeprecatedPublicIPs() {
        return this.deprecatedPublicIPs;
    }

    public T withDeprecatedPublicIPs(List<String> deprecatedPublicIPs) {
        this.deprecatedPublicIPs.clear();
        if (deprecatedPublicIPs != null) {
            for (String item : deprecatedPublicIPs) {
                this.addToDeprecatedPublicIPs(item);
            }
        }
        return (T)this;
    }

    public T withDeprecatedPublicIPs(String ... deprecatedPublicIPs) {
        this.deprecatedPublicIPs.clear();
        if (deprecatedPublicIPs != null) {
            for (String item : deprecatedPublicIPs) {
                this.addToDeprecatedPublicIPs(item);
            }
        }
        return (T)this;
    }

    public T addToPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)this;
    }

    public List<ServicePort> getPorts() {
        return this.build(this.ports);
    }

    public T withPorts(List<ServicePort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    public T withPorts(ServicePort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    public PortsNested<T> addNewPort() {
        return new PortsNested();
    }

    public PortsNested<T> addNewPortLike(ServicePort item) {
        return new PortsNested(item);
    }

    public T addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (T)this;
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public T withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (T)this;
    }

    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    public T withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return (T)this;
    }

    public String getType() {
        return this.type;
    }

    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class PortsNested<N>
    extends ServicePortFluent<PortsNested<N>>
    implements Nested<N> {
        private final ServicePortBuilder builder;

        PortsNested(ServicePort item) {
            this.builder = new ServicePortBuilder(this, item);
        }

        PortsNested() {
            this.builder = new ServicePortBuilder(this);
        }

        public N endPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluent.this.addToPorts(this.builder.build());
        }
    }
}

