/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"awsElasticBlockStore", "emptyDir", "gcePersistentDisk", "gitRepo", "glusterfs", "hostPath", "iscsi", "name", "nfs", "persistentVolumeClaim", "rbd", "secret"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Volume {
    @JsonProperty(value="awsElasticBlockStore")
    @Valid
    private AWSElasticBlockStoreVolumeSource awsElasticBlockStore;
    @JsonProperty(value="emptyDir")
    @Valid
    private EmptyDirVolumeSource emptyDir;
    @JsonProperty(value="gcePersistentDisk")
    @Valid
    private GCEPersistentDiskVolumeSource gcePersistentDisk;
    @JsonProperty(value="gitRepo")
    @Valid
    private GitRepoVolumeSource gitRepo;
    @JsonProperty(value="glusterfs")
    @Valid
    private GlusterfsVolumeSource glusterfs;
    @JsonProperty(value="hostPath")
    @Valid
    private HostPathVolumeSource hostPath;
    @JsonProperty(value="iscsi")
    @Valid
    private ISCSIVolumeSource iscsi;
    @JsonProperty(value="name")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max=63)
    private String name;
    @JsonProperty(value="nfs")
    @Valid
    private NFSVolumeSource nfs;
    @JsonProperty(value="persistentVolumeClaim")
    @Valid
    private PersistentVolumeClaimVolumeSource persistentVolumeClaim;
    @JsonProperty(value="rbd")
    @Valid
    private RBDVolumeSource rbd;
    @JsonProperty(value="secret")
    @Valid
    private SecretVolumeSource secret;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Volume() {
    }

    public Volume(AWSElasticBlockStoreVolumeSource awsElasticBlockStore, EmptyDirVolumeSource emptyDir, GCEPersistentDiskVolumeSource gcePersistentDisk, GitRepoVolumeSource gitRepo, GlusterfsVolumeSource glusterfs, HostPathVolumeSource hostPath, ISCSIVolumeSource iscsi, String name, NFSVolumeSource nfs, PersistentVolumeClaimVolumeSource persistentVolumeClaim, RBDVolumeSource rbd, SecretVolumeSource secret) {
        this.awsElasticBlockStore = awsElasticBlockStore;
        this.emptyDir = emptyDir;
        this.gcePersistentDisk = gcePersistentDisk;
        this.gitRepo = gitRepo;
        this.glusterfs = glusterfs;
        this.hostPath = hostPath;
        this.iscsi = iscsi;
        this.name = name;
        this.nfs = nfs;
        this.persistentVolumeClaim = persistentVolumeClaim;
        this.rbd = rbd;
        this.secret = secret;
    }

    @JsonProperty(value="awsElasticBlockStore")
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore;
    }

    @JsonProperty(value="awsElasticBlockStore")
    public void setAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        this.awsElasticBlockStore = awsElasticBlockStore;
    }

    @JsonProperty(value="emptyDir")
    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir;
    }

    @JsonProperty(value="emptyDir")
    public void setEmptyDir(EmptyDirVolumeSource emptyDir) {
        this.emptyDir = emptyDir;
    }

    @JsonProperty(value="gcePersistentDisk")
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk;
    }

    @JsonProperty(value="gcePersistentDisk")
    public void setGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        this.gcePersistentDisk = gcePersistentDisk;
    }

    @JsonProperty(value="gitRepo")
    public GitRepoVolumeSource getGitRepo() {
        return this.gitRepo;
    }

    @JsonProperty(value="gitRepo")
    public void setGitRepo(GitRepoVolumeSource gitRepo) {
        this.gitRepo = gitRepo;
    }

    @JsonProperty(value="glusterfs")
    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs;
    }

    @JsonProperty(value="glusterfs")
    public void setGlusterfs(GlusterfsVolumeSource glusterfs) {
        this.glusterfs = glusterfs;
    }

    @JsonProperty(value="hostPath")
    public HostPathVolumeSource getHostPath() {
        return this.hostPath;
    }

    @JsonProperty(value="hostPath")
    public void setHostPath(HostPathVolumeSource hostPath) {
        this.hostPath = hostPath;
    }

    @JsonProperty(value="iscsi")
    public ISCSIVolumeSource getIscsi() {
        return this.iscsi;
    }

    @JsonProperty(value="iscsi")
    public void setIscsi(ISCSIVolumeSource iscsi) {
        this.iscsi = iscsi;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="nfs")
    public NFSVolumeSource getNfs() {
        return this.nfs;
    }

    @JsonProperty(value="nfs")
    public void setNfs(NFSVolumeSource nfs) {
        this.nfs = nfs;
    }

    @JsonProperty(value="persistentVolumeClaim")
    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    @JsonProperty(value="persistentVolumeClaim")
    public void setPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
    }

    @JsonProperty(value="rbd")
    public RBDVolumeSource getRbd() {
        return this.rbd;
    }

    @JsonProperty(value="rbd")
    public void setRbd(RBDVolumeSource rbd) {
        this.rbd = rbd;
    }

    @JsonProperty(value="secret")
    public SecretVolumeSource getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    public void setSecret(SecretVolumeSource secret) {
        this.secret = secret;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "Volume(awsElasticBlockStore=" + this.getAwsElasticBlockStore() + ", emptyDir=" + this.getEmptyDir() + ", gcePersistentDisk=" + this.getGcePersistentDisk() + ", gitRepo=" + this.getGitRepo() + ", glusterfs=" + this.getGlusterfs() + ", hostPath=" + this.getHostPath() + ", iscsi=" + this.getIscsi() + ", name=" + this.getName() + ", nfs=" + this.getNfs() + ", persistentVolumeClaim=" + this.getPersistentVolumeClaim() + ", rbd=" + this.getRbd() + ", secret=" + this.getSecret() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AWSElasticBlockStoreVolumeSource this$awsElasticBlockStore = this.getAwsElasticBlockStore();
        AWSElasticBlockStoreVolumeSource other$awsElasticBlockStore = other.getAwsElasticBlockStore();
        if (this$awsElasticBlockStore == null ? other$awsElasticBlockStore != null : !((Object)this$awsElasticBlockStore).equals(other$awsElasticBlockStore)) {
            return false;
        }
        EmptyDirVolumeSource this$emptyDir = this.getEmptyDir();
        EmptyDirVolumeSource other$emptyDir = other.getEmptyDir();
        if (this$emptyDir == null ? other$emptyDir != null : !((Object)this$emptyDir).equals(other$emptyDir)) {
            return false;
        }
        GCEPersistentDiskVolumeSource this$gcePersistentDisk = this.getGcePersistentDisk();
        GCEPersistentDiskVolumeSource other$gcePersistentDisk = other.getGcePersistentDisk();
        if (this$gcePersistentDisk == null ? other$gcePersistentDisk != null : !((Object)this$gcePersistentDisk).equals(other$gcePersistentDisk)) {
            return false;
        }
        GitRepoVolumeSource this$gitRepo = this.getGitRepo();
        GitRepoVolumeSource other$gitRepo = other.getGitRepo();
        if (this$gitRepo == null ? other$gitRepo != null : !((Object)this$gitRepo).equals(other$gitRepo)) {
            return false;
        }
        GlusterfsVolumeSource this$glusterfs = this.getGlusterfs();
        GlusterfsVolumeSource other$glusterfs = other.getGlusterfs();
        if (this$glusterfs == null ? other$glusterfs != null : !((Object)this$glusterfs).equals(other$glusterfs)) {
            return false;
        }
        HostPathVolumeSource this$hostPath = this.getHostPath();
        HostPathVolumeSource other$hostPath = other.getHostPath();
        if (this$hostPath == null ? other$hostPath != null : !((Object)this$hostPath).equals(other$hostPath)) {
            return false;
        }
        ISCSIVolumeSource this$iscsi = this.getIscsi();
        ISCSIVolumeSource other$iscsi = other.getIscsi();
        if (this$iscsi == null ? other$iscsi != null : !((Object)this$iscsi).equals(other$iscsi)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NFSVolumeSource this$nfs = this.getNfs();
        NFSVolumeSource other$nfs = other.getNfs();
        if (this$nfs == null ? other$nfs != null : !((Object)this$nfs).equals(other$nfs)) {
            return false;
        }
        PersistentVolumeClaimVolumeSource this$persistentVolumeClaim = this.getPersistentVolumeClaim();
        PersistentVolumeClaimVolumeSource other$persistentVolumeClaim = other.getPersistentVolumeClaim();
        if (this$persistentVolumeClaim == null ? other$persistentVolumeClaim != null : !((Object)this$persistentVolumeClaim).equals(other$persistentVolumeClaim)) {
            return false;
        }
        RBDVolumeSource this$rbd = this.getRbd();
        RBDVolumeSource other$rbd = other.getRbd();
        if (this$rbd == null ? other$rbd != null : !((Object)this$rbd).equals(other$rbd)) {
            return false;
        }
        SecretVolumeSource this$secret = this.getSecret();
        SecretVolumeSource other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !((Object)this$secret).equals(other$secret)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Volume;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AWSElasticBlockStoreVolumeSource $awsElasticBlockStore = this.getAwsElasticBlockStore();
        result = result * 59 + ($awsElasticBlockStore == null ? 0 : ((Object)$awsElasticBlockStore).hashCode());
        EmptyDirVolumeSource $emptyDir = this.getEmptyDir();
        result = result * 59 + ($emptyDir == null ? 0 : ((Object)$emptyDir).hashCode());
        GCEPersistentDiskVolumeSource $gcePersistentDisk = this.getGcePersistentDisk();
        result = result * 59 + ($gcePersistentDisk == null ? 0 : ((Object)$gcePersistentDisk).hashCode());
        GitRepoVolumeSource $gitRepo = this.getGitRepo();
        result = result * 59 + ($gitRepo == null ? 0 : ((Object)$gitRepo).hashCode());
        GlusterfsVolumeSource $glusterfs = this.getGlusterfs();
        result = result * 59 + ($glusterfs == null ? 0 : ((Object)$glusterfs).hashCode());
        HostPathVolumeSource $hostPath = this.getHostPath();
        result = result * 59 + ($hostPath == null ? 0 : ((Object)$hostPath).hashCode());
        ISCSIVolumeSource $iscsi = this.getIscsi();
        result = result * 59 + ($iscsi == null ? 0 : ((Object)$iscsi).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        NFSVolumeSource $nfs = this.getNfs();
        result = result * 59 + ($nfs == null ? 0 : ((Object)$nfs).hashCode());
        PersistentVolumeClaimVolumeSource $persistentVolumeClaim = this.getPersistentVolumeClaim();
        result = result * 59 + ($persistentVolumeClaim == null ? 0 : ((Object)$persistentVolumeClaim).hashCode());
        RBDVolumeSource $rbd = this.getRbd();
        result = result * 59 + ($rbd == null ? 0 : ((Object)$rbd).hashCode());
        SecretVolumeSource $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 0 : ((Object)$secret).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

