package io.fabric8.kubernetes.api.builder;

import java.util.Set;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ArrayList;

public class BaseFluent<T> implements Fluent<T>, Visitable<T>{


    public final List<Visitable> _visitables = new ArrayList<Visitable>();

    public <T> ArrayList<T> build( List<? extends Builder<T>> list){
    ArrayList<T> r = new ArrayList<>();for (Builder<T> b : list) {    r.add(b.build());}return r;
}
    public <T> LinkedHashSet<T> build( LinkedHashSet<? extends Builder<T>> set){
    LinkedHashSet<T> r = new LinkedHashSet<>();for (Builder<T> b : set) {    r.add(b.build());}return r;
}
    public <T> ArrayList<T> aggregate( List<? extends T> ...lists){
    ArrayList<T> result = new ArrayList<>();for (List<? extends T> list : lists) {    result.addAll(list);}return result;
}
    public <T> LinkedHashSet<T> aggregate( Set<? extends T> ...sets){
    LinkedHashSet<T> result = new LinkedHashSet<>();for (Set<? extends T> set : sets) {    result.addAll(set);}return result;
}
    public T accept( Visitor visitor){
    for (Visitable v : _visitables) {    v.accept(visitor);}visitor.visit(this);return (T) this;
}


}
