package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ISCSIVolumeSourceBuilder extends ISCSIVolumeSourceFluent<ISCSIVolumeSourceBuilder> implements VisitableBuilder<ISCSIVolumeSource,ISCSIVolumeSourceBuilder>{

     ISCSIVolumeSourceFluent<?> fluent;
public ISCSIVolumeSourceBuilder(){
    this(new ISCSIVolumeSource());
}
public ISCSIVolumeSourceBuilder( ISCSIVolumeSourceFluent<?> fluent ){
    this(fluent, new ISCSIVolumeSource());
}
public ISCSIVolumeSourceBuilder( ISCSIVolumeSourceFluent<?> fluent , ISCSIVolumeSource instance ){
    this.fluent = fluent; fluent.withFsType(instance.getFsType()); fluent.withIqn(instance.getIqn()); fluent.withLun(instance.getLun()); fluent.withReadOnly(instance.getReadOnly()); fluent.withTargetPortal(instance.getTargetPortal()); 
}
public ISCSIVolumeSourceBuilder( ISCSIVolumeSource instance ){
    this.fluent = this; this.withFsType(instance.getFsType()); this.withIqn(instance.getIqn()); this.withLun(instance.getLun()); this.withReadOnly(instance.getReadOnly()); this.withTargetPortal(instance.getTargetPortal()); 
}

public EditableISCSIVolumeSource build(){
    EditableISCSIVolumeSource buildable = new EditableISCSIVolumeSource(fluent.getFsType(),fluent.getIqn(),fluent.getLun(),fluent.isReadOnly(),fluent.getTargetPortal());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ISCSIVolumeSourceBuilder that = (ISCSIVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    