package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class VolumeMountFluent<T extends VolumeMountFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String mountPath;     String name;     Boolean readOnly;     Map<String, Object> additionalProperties = new HashMap();

    public String getMountPath(){
    return this.mountPath;
    }
    public T withMountPath( String mountPath){
    this.mountPath=mountPath; return (T) this;
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public T withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
VolumeMountFluent that = (VolumeMountFluent) o;
if (mountPath != null ? !mountPath.equals(that.mountPath) :that.mountPath != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
