package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamedRoleFluent<T extends NamedRoleFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String name;     VisitableBuilder<Role, ?> role;     Map<String, Object> additionalProperties = new HashMap();

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public Role getRole(){
    return this.role!=null?this.role.build():null;
    }
    public T withRole( Role role){
    if (role!=null){ this.role= new RoleBuilder(role); _visitables.add(this.role);} return (T) this;
    }
    public RoleNested<T> withNewRole(){
    return new RoleNested<T>();
    }
    public RoleNested<T> withNewRoleLike( Role item){
    return new RoleNested<T>(item);
    }
    public RoleNested<T> editRole(){
    return withNewRoleLike(getRole());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedRoleFluent that = (NamedRoleFluent) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (role != null ? !role.equals(that.role) :that.role != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RoleNested<N> extends RoleFluent<RoleNested<N>> implements Nested<N>{

        private final RoleBuilder builder;
    
             RoleNested (){
        this.builder = new RoleBuilder(this);
        }
             RoleNested ( Role item){
        this.builder = new RoleBuilder(this, item);
        }
    
            public N endRole(){
            return and();
        }
            public N and(){
            return (N) NamedRoleFluent.this.withRole(builder.build());
        }
    
}


}
