package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class RecreateDeploymentStrategyParamsBuilder extends RecreateDeploymentStrategyParamsFluent<RecreateDeploymentStrategyParamsBuilder> implements VisitableBuilder<RecreateDeploymentStrategyParams,RecreateDeploymentStrategyParamsBuilder>{

     RecreateDeploymentStrategyParamsFluent<?> fluent;
public RecreateDeploymentStrategyParamsBuilder(){
    this(new RecreateDeploymentStrategyParams());
}
public RecreateDeploymentStrategyParamsBuilder( RecreateDeploymentStrategyParamsFluent<?> fluent ){
    this(fluent, new RecreateDeploymentStrategyParams());
}
public RecreateDeploymentStrategyParamsBuilder( RecreateDeploymentStrategyParamsFluent<?> fluent , RecreateDeploymentStrategyParams instance ){
    this.fluent = fluent; fluent.withPost(instance.getPost()); fluent.withPre(instance.getPre()); 
}
public RecreateDeploymentStrategyParamsBuilder( RecreateDeploymentStrategyParams instance ){
    this.fluent = this; this.withPost(instance.getPost()); this.withPre(instance.getPre()); 
}

public EditableRecreateDeploymentStrategyParams build(){
    EditableRecreateDeploymentStrategyParams buildable = new EditableRecreateDeploymentStrategyParams(fluent.getPost(),fluent.getPre());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RecreateDeploymentStrategyParamsBuilder that = (RecreateDeploymentStrategyParamsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    