package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class AWSElasticBlockStoreVolumeSourceBuilder extends AWSElasticBlockStoreVolumeSourceFluent<AWSElasticBlockStoreVolumeSourceBuilder> implements VisitableBuilder<AWSElasticBlockStoreVolumeSource,AWSElasticBlockStoreVolumeSourceBuilder>{

     AWSElasticBlockStoreVolumeSourceFluent<?> fluent;
public AWSElasticBlockStoreVolumeSourceBuilder(){
    this(new AWSElasticBlockStoreVolumeSource());
}
public AWSElasticBlockStoreVolumeSourceBuilder( AWSElasticBlockStoreVolumeSourceFluent<?> fluent ){
    this(fluent, new AWSElasticBlockStoreVolumeSource());
}
public AWSElasticBlockStoreVolumeSourceBuilder( AWSElasticBlockStoreVolumeSourceFluent<?> fluent , AWSElasticBlockStoreVolumeSource instance ){
    this.fluent = fluent; fluent.withFsType(instance.getFsType()); fluent.withPartition(instance.getPartition()); fluent.withReadOnly(instance.getReadOnly()); fluent.withVolumeID(instance.getVolumeID()); 
}
public AWSElasticBlockStoreVolumeSourceBuilder( AWSElasticBlockStoreVolumeSource instance ){
    this.fluent = this; this.withFsType(instance.getFsType()); this.withPartition(instance.getPartition()); this.withReadOnly(instance.getReadOnly()); this.withVolumeID(instance.getVolumeID()); 
}

public EditableAWSElasticBlockStoreVolumeSource build(){
    EditableAWSElasticBlockStoreVolumeSource buildable = new EditableAWSElasticBlockStoreVolumeSource(fluent.getFsType(),fluent.getPartition(),fluent.isReadOnly(),fluent.getVolumeID());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
AWSElasticBlockStoreVolumeSourceBuilder that = (AWSElasticBlockStoreVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    