
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "addresses",
    "capacity",
    "conditions",
    "nodeInfo",
    "phase"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class NodeStatus {

    /**
     * list of addresses reachable to the node; see http://releases.k8s.io/HEAD/docs/admin/node.md#node-addresses
     * 
     */
    @JsonProperty("addresses")
    @Valid
    private List<NodeAddress> addresses = new ArrayList<NodeAddress>();
    /**
     * compute resource capacity of the node; see http://releases.k8s.io/HEAD/docs/user-guide/compute-resources.md
     * 
     */
    @JsonProperty("capacity")
    @Valid
    private Map<String, Quantity> capacity;
    /**
     * list of node conditions observed; see http://releases.k8s.io/HEAD/docs/admin/node.md#node-condition
     * 
     */
    @JsonProperty("conditions")
    @Valid
    private List<NodeCondition> conditions = new ArrayList<NodeCondition>();
    /**
     * 
     * 
     */
    @JsonProperty("nodeInfo")
    @Valid
    private NodeSystemInfo nodeInfo;
    /**
     * most recently observed lifecycle phase of the node; see http://releases.k8s.io/HEAD/docs/admin/node.md#node-phase
     * 
     */
    @JsonProperty("phase")
    private java.lang.String phase;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public NodeStatus() {
    }

    /**
     * 
     * @param phase
     * @param addresses
     * @param nodeInfo
     * @param conditions
     * @param capacity
     */
    public NodeStatus(List<NodeAddress> addresses, Map<String, Quantity> capacity, List<NodeCondition> conditions, NodeSystemInfo nodeInfo, java.lang.String phase) {
        this.addresses = addresses;
        this.capacity = capacity;
        this.conditions = conditions;
        this.nodeInfo = nodeInfo;
        this.phase = phase;
    }

    /**
     * list of addresses reachable to the node; see http://releases.k8s.io/HEAD/docs/admin/node.md#node-addresses
     * 
     * @return
     *     The addresses
     */
    @JsonProperty("addresses")
    public List<NodeAddress> getAddresses() {
        return addresses;
    }

    /**
     * list of addresses reachable to the node; see http://releases.k8s.io/HEAD/docs/admin/node.md#node-addresses
     * 
     * @param addresses
     *     The addresses
     */
    @JsonProperty("addresses")
    public void setAddresses(List<NodeAddress> addresses) {
        this.addresses = addresses;
    }

    /**
     * compute resource capacity of the node; see http://releases.k8s.io/HEAD/docs/user-guide/compute-resources.md
     * 
     * @return
     *     The capacity
     */
    @JsonProperty("capacity")
    public Map<String, Quantity> getCapacity() {
        return capacity;
    }

    /**
     * compute resource capacity of the node; see http://releases.k8s.io/HEAD/docs/user-guide/compute-resources.md
     * 
     * @param capacity
     *     The capacity
     */
    @JsonProperty("capacity")
    public void setCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    /**
     * list of node conditions observed; see http://releases.k8s.io/HEAD/docs/admin/node.md#node-condition
     * 
     * @return
     *     The conditions
     */
    @JsonProperty("conditions")
    public List<NodeCondition> getConditions() {
        return conditions;
    }

    /**
     * list of node conditions observed; see http://releases.k8s.io/HEAD/docs/admin/node.md#node-condition
     * 
     * @param conditions
     *     The conditions
     */
    @JsonProperty("conditions")
    public void setConditions(List<NodeCondition> conditions) {
        this.conditions = conditions;
    }

    /**
     * 
     * 
     * @return
     *     The nodeInfo
     */
    @JsonProperty("nodeInfo")
    public NodeSystemInfo getNodeInfo() {
        return nodeInfo;
    }

    /**
     * 
     * 
     * @param nodeInfo
     *     The nodeInfo
     */
    @JsonProperty("nodeInfo")
    public void setNodeInfo(NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    /**
     * most recently observed lifecycle phase of the node; see http://releases.k8s.io/HEAD/docs/admin/node.md#node-phase
     * 
     * @return
     *     The phase
     */
    @JsonProperty("phase")
    public java.lang.String getPhase() {
        return phase;
    }

    /**
     * most recently observed lifecycle phase of the node; see http://releases.k8s.io/HEAD/docs/admin/node.md#node-phase
     * 
     * @param phase
     *     The phase
     */
    @JsonProperty("phase")
    public void setPhase(java.lang.String phase) {
        this.phase = phase;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
