package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class PersistentVolumeClaimSpecBuilder extends PersistentVolumeClaimSpecFluent<PersistentVolumeClaimSpecBuilder> implements VisitableBuilder<PersistentVolumeClaimSpec,PersistentVolumeClaimSpecBuilder>{

     PersistentVolumeClaimSpecFluent<?> fluent;
public PersistentVolumeClaimSpecBuilder(){
    this(new PersistentVolumeClaimSpec());
}
public PersistentVolumeClaimSpecBuilder( PersistentVolumeClaimSpecFluent<?> fluent ){
    this(fluent, new PersistentVolumeClaimSpec());
}
public PersistentVolumeClaimSpecBuilder( PersistentVolumeClaimSpecFluent<?> fluent , PersistentVolumeClaimSpec instance ){
    this.fluent = fluent; fluent.withAccessModes(instance.getAccessModes()); fluent.withResources(instance.getResources()); fluent.withVolumeName(instance.getVolumeName()); 
}
public PersistentVolumeClaimSpecBuilder( PersistentVolumeClaimSpec instance ){
    this.fluent = this; this.withAccessModes(instance.getAccessModes()); this.withResources(instance.getResources()); this.withVolumeName(instance.getVolumeName()); 
}

public EditablePersistentVolumeClaimSpec build(){
    EditablePersistentVolumeClaimSpec buildable = new EditablePersistentVolumeClaimSpec(fluent.getAccessModes(),fluent.getResources(),fluent.getVolumeName());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PersistentVolumeClaimSpecBuilder that = (PersistentVolumeClaimSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    