package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class StatusFluent<T extends StatusFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Status.ApiVersion apiVersion;     Integer code;     VisitableBuilder<StatusDetails, ?> details;     String kind;     String message;     VisitableBuilder<ListMeta, ?> metadata;     String reason;     String status;     Map<String, Object> additionalProperties = new HashMap();

    public Status.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Status.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public Integer getCode(){
    return this.code;
    }
    public T withCode( Integer code){
    this.code=code; return (T) this;
    }
    public StatusDetails getDetails(){
    return this.details!=null?this.details.build():null;
    }
    public T withDetails( StatusDetails details){
    if (details!=null){ this.details= new StatusDetailsBuilder(details); _visitables.add(this.details);} return (T) this;
    }
    public DetailsNested<T> withNewDetails(){
    return new DetailsNested<T>();
    }
    public DetailsNested<T> withNewDetailsLike( StatusDetails item){
    return new DetailsNested<T>(item);
    }
    public DetailsNested<T> editDetails(){
    return withNewDetailsLike(getDetails());
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public String getReason(){
    return this.reason;
    }
    public T withReason( String reason){
    this.reason=reason; return (T) this;
    }
    public String getStatus(){
    return this.status;
    }
    public T withStatus( String status){
    this.status=status; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
StatusFluent that = (StatusFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (code != null ? !code.equals(that.code) :that.code != null) return false;
if (details != null ? !details.equals(that.details) :that.details != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class DetailsNested<N> extends StatusDetailsFluent<DetailsNested<N>> implements Nested<N>{

        private final StatusDetailsBuilder builder;
    
             DetailsNested (){
        this.builder = new StatusDetailsBuilder(this);
        }
             DetailsNested ( StatusDetails item){
        this.builder = new StatusDetailsBuilder(this, item);
        }
    
            public N and(){
            return (N) StatusFluent.this.withDetails(builder.build());
        }
            public N endDetails(){
            return and();
        }
    
}
    public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNested ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ListMetaBuilder(this);
        }
    
            public N and(){
            return (N) StatusFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
