package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class BuildRequestBuilder extends BuildRequestFluent<BuildRequestBuilder> implements VisitableBuilder<BuildRequest,BuildRequestBuilder>{

     BuildRequestFluent<?> fluent;
public BuildRequestBuilder(){
    this(new BuildRequest());
}
public BuildRequestBuilder( BuildRequestFluent<?> fluent ){
    this(fluent, new BuildRequest());
}
public BuildRequestBuilder( BuildRequestFluent<?> fluent , BuildRequest instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withFrom(instance.getFrom()); fluent.withKind(instance.getKind()); fluent.withLastVersion(instance.getLastVersion()); fluent.withMetadata(instance.getMetadata()); fluent.withRevision(instance.getRevision()); fluent.withTriggeredByImage(instance.getTriggeredByImage()); 
}
public BuildRequestBuilder( BuildRequest instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withFrom(instance.getFrom()); this.withKind(instance.getKind()); this.withLastVersion(instance.getLastVersion()); this.withMetadata(instance.getMetadata()); this.withRevision(instance.getRevision()); this.withTriggeredByImage(instance.getTriggeredByImage()); 
}

public EditableBuildRequest build(){
    EditableBuildRequest buildable = new EditableBuildRequest(fluent.getApiVersion(),fluent.getFrom(),fluent.getKind(),fluent.getLastVersion(),fluent.getMetadata(),fluent.getRevision(),fluent.getTriggeredByImage());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildRequestBuilder that = (BuildRequestBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    