/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ClusterFluent;
import io.fabric8.kubernetes.api.model.EditableCluster;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ClusterBuilder
extends ClusterFluent<ClusterBuilder>
implements VisitableBuilder<Cluster, ClusterBuilder> {
    ClusterFluent<?> fluent;

    public ClusterBuilder() {
        this(new Cluster());
    }

    public ClusterBuilder(ClusterFluent<?> fluent) {
        this(fluent, new Cluster());
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Cluster instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCertificateAuthority(instance.getCertificateAuthority());
        fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        fluent.withExtensions(instance.getExtensions());
        fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        fluent.withServer(instance.getServer());
    }

    public ClusterBuilder(Cluster instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withCertificateAuthority(instance.getCertificateAuthority());
        this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        this.withExtensions(instance.getExtensions());
        this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        this.withServer(instance.getServer());
    }

    @Override
    public EditableCluster build() {
        EditableCluster buildable = new EditableCluster(this.fluent.getApiVersion(), this.fluent.getCertificateAuthority(), this.fluent.getCertificateAuthorityData(), this.fluent.getExtensions(), this.fluent.isInsecureSkipTlsVerify(), this.fluent.getServer());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterBuilder that = (ClusterBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

