/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodSpecFluent<T extends PodSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Long activeDeadlineSeconds;
    List<VisitableBuilder<Container, ?>> containers = new ArrayList();
    String dnsPolicy;
    String host;
    Boolean hostNetwork;
    List<VisitableBuilder<LocalObjectReference, ?>> imagePullSecrets = new ArrayList();
    String nodeName;
    Map<String, String> nodeSelector = new HashMap<String, String>();
    String restartPolicy;
    String serviceAccount;
    String serviceAccountName;
    Long terminationGracePeriodSeconds;
    List<VisitableBuilder<Volume, ?>> volumes = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public T withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (T)this;
    }

    public T addToContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.add(builder);
            this.containers.add(builder);
        }
        return (T)this;
    }

    public T removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.remove(builder);
            this.containers.remove(builder);
        }
        return (T)this;
    }

    public List<Container> getContainers() {
        return this.build(this.containers);
    }

    public T withContainers(List<Container> containers) {
        this.containers.clear();
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (T)this;
    }

    public T withContainers(Container ... containers) {
        this.containers.clear();
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (T)this;
    }

    public ContainersNested<T> addNewContainer() {
        return new ContainersNested();
    }

    public ContainersNested<T> addNewContainerLike(Container item) {
        return new ContainersNested(item);
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public T withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (T)this;
    }

    public String getHost() {
        return this.host;
    }

    public T withHost(String host) {
        this.host = host;
        return (T)this;
    }

    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    public T withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (T)this;
    }

    public T addToImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (T)this;
    }

    public T removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (T)this;
    }

    public List<LocalObjectReference> getImagePullSecrets() {
        return this.build(this.imagePullSecrets);
    }

    public T withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (T)this;
    }

    public T withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (T)this;
    }

    public ImagePullSecretsNested<T> addNewImagePullSecret() {
        return new ImagePullSecretsNested();
    }

    public ImagePullSecretsNested<T> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNested(item);
    }

    public T addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public T withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (T)this;
    }

    public T addToNodeSelector(String key, String value) {
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (T)this;
    }

    public T removeFromNodeSelector(String key) {
        if (key != null) {
            this.nodeSelector.remove(key);
        }
        return (T)this;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public T withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector.clear();
        if (nodeSelector != null) {
            this.nodeSelector.putAll(nodeSelector);
        }
        return (T)this;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public T withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (T)this;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public T withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (T)this;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public T withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (T)this;
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public T withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (T)this;
    }

    public T addToVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.add(builder);
            this.volumes.add(builder);
        }
        return (T)this;
    }

    public T removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.remove(builder);
            this.volumes.remove(builder);
        }
        return (T)this;
    }

    public List<Volume> getVolumes() {
        return this.build(this.volumes);
    }

    public T withVolumes(List<Volume> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (T)this;
    }

    public T withVolumes(Volume ... volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (T)this;
    }

    public VolumesNested<T> addNewVolume() {
        return new VolumesNested();
    }

    public VolumesNested<T> addNewVolumeLike(Volume item) {
        return new VolumesNested(item);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSpecFluent that = (PodSpecFluent)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != null ? !this.terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) : that.terminationGracePeriodSeconds != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class VolumesNested<N>
    extends VolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        private final VolumeBuilder builder;

        VolumesNested() {
            this.builder = new VolumeBuilder(this);
        }

        VolumesNested(Volume item) {
            this.builder = new VolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.addToVolumes(this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }

    public class ImagePullSecretsNested<N>
    extends LocalObjectReferenceFluent<ImagePullSecretsNested<N>>
    implements Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        ImagePullSecretsNested() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        ImagePullSecretsNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.addToImagePullSecrets(this.builder.build());
        }

        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class ContainersNested<N>
    extends ContainerFluent<ContainersNested<N>>
    implements Nested<N> {
        private final ContainerBuilder builder;

        ContainersNested() {
            this.builder = new ContainerBuilder(this);
        }

        ContainersNested(Container item) {
            this.builder = new ContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluent.this.addToContainers(this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }
}

