/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterRoleBindingFluent<T extends ClusterRoleBindingFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    ClusterRoleBinding.ApiVersion apiVersion;
    List<String> groupNames = new ArrayList<String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ObjectReference, ?> roleRef;
    List<VisitableBuilder<ObjectReference, ?>> subjects = new ArrayList();
    List<String> userNames = new ArrayList<String>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ClusterRoleBinding.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(ClusterRoleBinding.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToGroupNames(String ... items) {
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (T)this;
    }

    public T removeFromGroupNames(String ... items) {
        for (String item : items) {
            this.groupNames.remove(item);
        }
        return (T)this;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public T withGroupNames(List<String> groupNames) {
        this.groupNames.clear();
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (T)this;
    }

    public T withGroupNames(String ... groupNames) {
        this.groupNames.clear();
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public ObjectReference getRoleRef() {
        return this.roleRef != null ? (ObjectReference)this.roleRef.build() : null;
    }

    public T withRoleRef(ObjectReference roleRef) {
        if (roleRef != null) {
            this.roleRef = new ObjectReferenceBuilder(roleRef);
            this._visitables.add(this.roleRef);
        }
        return (T)this;
    }

    public RoleRefNested<T> withNewRoleRef() {
        return new RoleRefNested();
    }

    public RoleRefNested<T> withNewRoleRefLike(ObjectReference item) {
        return new RoleRefNested(item);
    }

    public RoleRefNested<T> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    public T addToSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (T)this;
    }

    public T removeFromSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.subjects.remove(builder);
        }
        return (T)this;
    }

    public List<ObjectReference> getSubjects() {
        return this.build(this.subjects);
    }

    public T withSubjects(List<ObjectReference> subjects) {
        this.subjects.clear();
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (T)this;
    }

    public T withSubjects(ObjectReference ... subjects) {
        this.subjects.clear();
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (T)this;
    }

    public SubjectsNested<T> addNewSubject() {
        return new SubjectsNested();
    }

    public SubjectsNested<T> addNewSubjectLike(ObjectReference item) {
        return new SubjectsNested(item);
    }

    public T addToUserNames(String ... items) {
        for (String item : items) {
            this.userNames.add(item);
        }
        return (T)this;
    }

    public T removeFromUserNames(String ... items) {
        for (String item : items) {
            this.userNames.remove(item);
        }
        return (T)this;
    }

    public List<String> getUserNames() {
        return this.userNames;
    }

    public T withUserNames(List<String> userNames) {
        this.userNames.clear();
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (T)this;
    }

    public T withUserNames(String ... userNames) {
        this.userNames.clear();
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRoleBindingFluent that = (ClusterRoleBindingFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groupNames != null ? !this.groupNames.equals(that.groupNames) : that.groupNames != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        if (this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null) {
            return false;
        }
        if (this.userNames != null ? !this.userNames.equals(that.userNames) : that.userNames != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SubjectsNested<N>
    extends ObjectReferenceFluent<SubjectsNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        SubjectsNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        SubjectsNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluent.this.addToSubjects(this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNested<N>
    extends ObjectReferenceFluent<RoleRefNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        RoleRefNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        RoleRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N endRoleRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluent.this.withRoleRef(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

