package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class GlusterfsVolumeSourceFluent<T extends GlusterfsVolumeSourceFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String endpoints;     String path;     Boolean readOnly;     Map<String, Object> additionalProperties = new HashMap();

    public String getEndpoints(){
    return this.endpoints;
    }
    public T withEndpoints( String endpoints){
    this.endpoints=endpoints; return (T) this;
    }
    public String getPath(){
    return this.path;
    }
    public T withPath( String path){
    this.path=path; return (T) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public T withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
GlusterfsVolumeSourceFluent that = (GlusterfsVolumeSourceFluent) o;
if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
if (path != null ? !path.equals(that.path) :that.path != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
