package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class StatusCauseBuilder extends StatusCauseFluent<StatusCauseBuilder> implements VisitableBuilder<StatusCause,StatusCauseBuilder>{

     StatusCauseFluent<?> fluent;
public StatusCauseBuilder(){
    this(new StatusCause());
}
public StatusCauseBuilder( StatusCauseFluent<?> fluent ){
    this(fluent, new StatusCause());
}
public StatusCauseBuilder( StatusCauseFluent<?> fluent , StatusCause instance ){
    this.fluent = fluent; fluent.withField(instance.getField()); fluent.withMessage(instance.getMessage()); fluent.withReason(instance.getReason()); 
}
public StatusCauseBuilder( StatusCause instance ){
    this.fluent = this; this.withField(instance.getField()); this.withMessage(instance.getMessage()); this.withReason(instance.getReason()); 
}

public EditableStatusCause build(){
    EditableStatusCause buildable = new EditableStatusCause(fluent.getField(),fluent.getMessage(),fluent.getReason());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
StatusCauseBuilder that = (StatusCauseBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    