package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class EventBuilder extends EventFluent<EventBuilder> implements VisitableBuilder<Event,EventBuilder>{

     EventFluent<?> fluent;
public EventBuilder(){
    this(new Event());
}
public EventBuilder( EventFluent<?> fluent ){
    this(fluent, new Event());
}
public EventBuilder( EventFluent<?> fluent , Event instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withCount(instance.getCount()); fluent.withFirstTimestamp(instance.getFirstTimestamp()); fluent.withInvolvedObject(instance.getInvolvedObject()); fluent.withKind(instance.getKind()); fluent.withLastTimestamp(instance.getLastTimestamp()); fluent.withMessage(instance.getMessage()); fluent.withMetadata(instance.getMetadata()); fluent.withReason(instance.getReason()); fluent.withSource(instance.getSource()); 
}
public EventBuilder( Event instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withCount(instance.getCount()); this.withFirstTimestamp(instance.getFirstTimestamp()); this.withInvolvedObject(instance.getInvolvedObject()); this.withKind(instance.getKind()); this.withLastTimestamp(instance.getLastTimestamp()); this.withMessage(instance.getMessage()); this.withMetadata(instance.getMetadata()); this.withReason(instance.getReason()); this.withSource(instance.getSource()); 
}

public EditableEvent build(){
    EditableEvent buildable = new EditableEvent(fluent.getApiVersion(),fluent.getCount(),fluent.getFirstTimestamp(),fluent.getInvolvedObject(),fluent.getKind(),fluent.getLastTimestamp(),fluent.getMessage(),fluent.getMetadata(),fluent.getReason(),fluent.getSource());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
EventBuilder that = (EventBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    