package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class LifecycleFluent<T extends LifecycleFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<Handler, ?> postStart;     VisitableBuilder<Handler, ?> preStop;     Map<String, Object> additionalProperties = new HashMap();

    public Handler getPostStart(){
    return this.postStart!=null?this.postStart.build():null;
    }
    public T withPostStart( Handler postStart){
    if (postStart!=null){ this.postStart= new HandlerBuilder(postStart); _visitables.add(this.postStart);} return (T) this;
    }
    public PostStartNested<T> withNewPostStart(){
    return new PostStartNested<T>();
    }
    public PostStartNested<T> withNewPostStartLike( Handler item){
    return new PostStartNested<T>(item);
    }
    public PostStartNested<T> editPostStart(){
    return withNewPostStartLike(getPostStart());
    }
    public Handler getPreStop(){
    return this.preStop!=null?this.preStop.build():null;
    }
    public T withPreStop( Handler preStop){
    if (preStop!=null){ this.preStop= new HandlerBuilder(preStop); _visitables.add(this.preStop);} return (T) this;
    }
    public PreStopNested<T> withNewPreStop(){
    return new PreStopNested<T>();
    }
    public PreStopNested<T> withNewPreStopLike( Handler item){
    return new PreStopNested<T>(item);
    }
    public PreStopNested<T> editPreStop(){
    return withNewPreStopLike(getPreStop());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LifecycleFluent that = (LifecycleFluent) o;
if (postStart != null ? !postStart.equals(that.postStart) :that.postStart != null) return false;
if (preStop != null ? !preStop.equals(that.preStop) :that.preStop != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class PostStartNested<N> extends HandlerFluent<PostStartNested<N>> implements Nested<N>{

        private final HandlerBuilder builder;
    
             PostStartNested (){
        this.builder = new HandlerBuilder(this);
        }
             PostStartNested ( Handler item){
        this.builder = new HandlerBuilder(this, item);
        }
    
            public N endPostStart(){
            return and();
        }
            public N and(){
            return (N) LifecycleFluent.this.withPostStart(builder.build());
        }
    
}
    public class PreStopNested<N> extends HandlerFluent<PreStopNested<N>> implements Nested<N>{

        private final HandlerBuilder builder;
    
             PreStopNested (){
        this.builder = new HandlerBuilder(this);
        }
             PreStopNested ( Handler item){
        this.builder = new HandlerBuilder(this, item);
        }
    
            public N and(){
            return (N) LifecycleFluent.this.withPreStop(builder.build());
        }
            public N endPreStop(){
            return and();
        }
    
}


}
