package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ClusterPolicyBuilder extends ClusterPolicyFluent<ClusterPolicyBuilder> implements VisitableBuilder<ClusterPolicy,ClusterPolicyBuilder>{

     ClusterPolicyFluent<?> fluent;
public ClusterPolicyBuilder(){
    this(new ClusterPolicy());
}
public ClusterPolicyBuilder( ClusterPolicyFluent<?> fluent ){
    this(fluent, new ClusterPolicy());
}
public ClusterPolicyBuilder( ClusterPolicyFluent<?> fluent , ClusterPolicy instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withKind(instance.getKind()); fluent.withLastModified(instance.getLastModified()); fluent.withMetadata(instance.getMetadata()); fluent.withRoles(instance.getRoles()); 
}
public ClusterPolicyBuilder( ClusterPolicy instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withLastModified(instance.getLastModified()); this.withMetadata(instance.getMetadata()); this.withRoles(instance.getRoles()); 
}

public EditableClusterPolicy build(){
    EditableClusterPolicy buildable = new EditableClusterPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.getLastModified(),fluent.getMetadata(),fluent.getRoles());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ClusterPolicyBuilder that = (ClusterPolicyBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    