/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.StatusDetailsBuilder;
import io.fabric8.kubernetes.api.model.StatusDetailsFluent;
import java.util.HashMap;
import java.util.Map;

public class StatusFluent<T extends StatusFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Status.ApiVersion apiVersion;
    Integer code;
    VisitableBuilder<StatusDetails, ?> details;
    String kind;
    String message;
    VisitableBuilder<ListMeta, ?> metadata;
    String reason;
    String status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Status.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Status.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public Integer getCode() {
        return this.code;
    }

    public T withCode(Integer code) {
        this.code = code;
        return (T)this;
    }

    public StatusDetails getDetails() {
        return this.details != null ? (StatusDetails)this.details.build() : null;
    }

    public T withDetails(StatusDetails details) {
        if (details != null) {
            this.details = new StatusDetailsBuilder(details);
            this._visitables.add(this.details);
        }
        return (T)this;
    }

    public DetailsNested<T> withNewDetails() {
        return new DetailsNested();
    }

    public DetailsNested<T> withNewDetailsLike(StatusDetails item) {
        return new DetailsNested(item);
    }

    public DetailsNested<T> editDetails() {
        return this.withNewDetailsLike(this.getDetails());
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public String getMessage() {
        return this.message;
    }

    public T withMessage(String message) {
        this.message = message;
        return (T)this;
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public String getReason() {
        return this.reason;
    }

    public T withReason(String reason) {
        this.reason = reason;
        return (T)this;
    }

    public String getStatus() {
        return this.status;
    }

    public T withStatus(String status) {
        this.status = status;
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusFluent that = (StatusFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNested() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatusFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class DetailsNested<N>
    extends StatusDetailsFluent<DetailsNested<N>>
    implements Nested<N> {
        private final StatusDetailsBuilder builder;

        DetailsNested(StatusDetails item) {
            this.builder = new StatusDetailsBuilder(this, item);
        }

        DetailsNested() {
            this.builder = new StatusDetailsBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatusFluent.this.withDetails(this.builder.build());
        }

        public N endDetails() {
            return this.and();
        }
    }
}

