package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class GitBuildSourceBuilder extends GitBuildSourceFluent<GitBuildSourceBuilder> implements VisitableBuilder<GitBuildSource,GitBuildSourceBuilder>{

     GitBuildSourceFluent<?> fluent;
public GitBuildSourceBuilder(){
    this(new GitBuildSource());
}
public GitBuildSourceBuilder( GitBuildSourceFluent<?> fluent ){
    this(fluent, new GitBuildSource());
}
public GitBuildSourceBuilder( GitBuildSourceFluent<?> fluent , GitBuildSource instance ){
    this.fluent = fluent; fluent.withHttpProxy(instance.getHttpProxy()); fluent.withHttpsProxy(instance.getHttpsProxy()); fluent.withRef(instance.getRef()); fluent.withUri(instance.getUri()); 
}
public GitBuildSourceBuilder( GitBuildSource instance ){
    this.fluent = this; this.withHttpProxy(instance.getHttpProxy()); this.withHttpsProxy(instance.getHttpsProxy()); this.withRef(instance.getRef()); this.withUri(instance.getUri()); 
}

public EditableGitBuildSource build(){
    EditableGitBuildSource buildable = new EditableGitBuildSource(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getRef(),fluent.getUri());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
GitBuildSourceBuilder that = (GitBuildSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    