/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableMetadataVolumeSource;
import io.fabric8.kubernetes.api.model.MetadataVolumeSource;
import io.fabric8.kubernetes.api.model.MetadataVolumeSourceFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class MetadataVolumeSourceBuilder
extends MetadataVolumeSourceFluent<MetadataVolumeSourceBuilder>
implements VisitableBuilder<MetadataVolumeSource, MetadataVolumeSourceBuilder> {
    MetadataVolumeSourceFluent<?> fluent;

    public MetadataVolumeSourceBuilder() {
        this(new MetadataVolumeSource());
    }

    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent) {
        this(fluent, new MetadataVolumeSource());
    }

    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent, MetadataVolumeSource instance) {
        this.fluent = fluent;
        fluent.withItems(instance.getItems());
    }

    public MetadataVolumeSourceBuilder(MetadataVolumeSource instance) {
        this.fluent = this;
        this.withItems(instance.getItems());
    }

    @Override
    public EditableMetadataVolumeSource build() {
        EditableMetadataVolumeSource buildable = new EditableMetadataVolumeSource(this.fluent.getItems());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataVolumeSourceBuilder that = (MetadataVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

