/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceSpecFluent<T extends ServiceSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    String clusterIP;
    List<String> deprecatedPublicIPs = new ArrayList<String>();
    String portalIP;
    List<VisitableBuilder<ServicePort, ?>> ports = new ArrayList();
    Map<String, String> selector = new HashMap<String, String>();
    String sessionAffinity;
    String type;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public String getClusterIP() {
        return this.clusterIP;
    }

    public T withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (T)this;
    }

    public T addToDeprecatedPublicIPs(String ... items) {
        for (String item : items) {
            this.deprecatedPublicIPs.add(item);
        }
        return (T)this;
    }

    public T removeFromDeprecatedPublicIPs(String ... items) {
        for (String item : items) {
            this.deprecatedPublicIPs.remove(item);
        }
        return (T)this;
    }

    public List<String> getDeprecatedPublicIPs() {
        return this.deprecatedPublicIPs;
    }

    public T withDeprecatedPublicIPs(List<String> deprecatedPublicIPs) {
        this.deprecatedPublicIPs.clear();
        if (deprecatedPublicIPs != null) {
            for (String item : deprecatedPublicIPs) {
                this.addToDeprecatedPublicIPs(item);
            }
        }
        return (T)this;
    }

    public T withDeprecatedPublicIPs(String ... deprecatedPublicIPs) {
        this.deprecatedPublicIPs.clear();
        if (deprecatedPublicIPs != null) {
            for (String item : deprecatedPublicIPs) {
                this.addToDeprecatedPublicIPs(item);
            }
        }
        return (T)this;
    }

    public String getPortalIP() {
        return this.portalIP;
    }

    public T withPortalIP(String portalIP) {
        this.portalIP = portalIP;
        return (T)this;
    }

    public T addToPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)this;
    }

    public T removeFromPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (T)this;
    }

    public List<ServicePort> getPorts() {
        return this.build(this.ports);
    }

    public T withPorts(List<ServicePort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    public T withPorts(ServicePort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    public PortsNested<T> addNewPort() {
        return new PortsNested();
    }

    public PortsNested<T> addNewPortLike(ServicePort item) {
        return new PortsNested(item);
    }

    public T addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (T)this;
    }

    public T removeFromSelector(String key) {
        if (key != null) {
            this.selector.remove(key);
        }
        return (T)this;
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public T withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (T)this;
    }

    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    public T withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return (T)this;
    }

    public String getType() {
        return this.type;
    }

    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecFluent that = (ServiceSpecFluent)o;
        if (this.clusterIP != null ? !this.clusterIP.equals(that.clusterIP) : that.clusterIP != null) {
            return false;
        }
        if (this.deprecatedPublicIPs != null ? !this.deprecatedPublicIPs.equals(that.deprecatedPublicIPs) : that.deprecatedPublicIPs != null) {
            return false;
        }
        if (this.portalIP != null ? !this.portalIP.equals(that.portalIP) : that.portalIP != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.sessionAffinity != null ? !this.sessionAffinity.equals(that.sessionAffinity) : that.sessionAffinity != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class PortsNested<N>
    extends ServicePortFluent<PortsNested<N>>
    implements Nested<N> {
        private final ServicePortBuilder builder;

        PortsNested() {
            this.builder = new ServicePortBuilder(this);
        }

        PortsNested(ServicePort item) {
            this.builder = new ServicePortBuilder(this, item);
        }

        public N endPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluent.this.addToPorts(this.builder.build());
        }
    }
}

