package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class VolumeFluent<T extends VolumeFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;     VisitableBuilder<CephFSVolumeSource, ?> cephfs;     VisitableBuilder<EmptyDirVolumeSource, ?> emptyDir;     VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;     VisitableBuilder<GitRepoVolumeSource, ?> gitRepo;     VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;     VisitableBuilder<HostPathVolumeSource, ?> hostPath;     VisitableBuilder<ISCSIVolumeSource, ?> iscsi;     VisitableBuilder<MetadataVolumeSource, ?> metadata;     String name;     VisitableBuilder<NFSVolumeSource, ?> nfs;     VisitableBuilder<PersistentVolumeClaimVolumeSource, ?> persistentVolumeClaim;     VisitableBuilder<RBDVolumeSource, ?> rbd;     VisitableBuilder<SecretVolumeSource, ?> secret;     Map<String, Object> additionalProperties = new HashMap();

    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore(){
    return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
    }
    public T withAwsElasticBlockStore( AWSElasticBlockStoreVolumeSource awsElasticBlockStore){
    if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.add(this.awsElasticBlockStore);} return (T) this;
    }
    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore(){
    return new AwsElasticBlockStoreNested<T>();
    }
    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike( AWSElasticBlockStoreVolumeSource item){
    return new AwsElasticBlockStoreNested<T>(item);
    }
    public AwsElasticBlockStoreNested<T> editAwsElasticBlockStore(){
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
    }
    public T withNewAwsElasticBlockStore( String fsType,  Integer partition,  Boolean readOnly,  String volumeID){
    return withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }
    public CephFSVolumeSource getCephfs(){
    return this.cephfs!=null?this.cephfs.build():null;
    }
    public T withCephfs( CephFSVolumeSource cephfs){
    if (cephfs!=null){ this.cephfs= new CephFSVolumeSourceBuilder(cephfs); _visitables.add(this.cephfs);} return (T) this;
    }
    public CephfsNested<T> withNewCephfs(){
    return new CephfsNested<T>();
    }
    public CephfsNested<T> withNewCephfsLike( CephFSVolumeSource item){
    return new CephfsNested<T>(item);
    }
    public CephfsNested<T> editCephfs(){
    return withNewCephfsLike(getCephfs());
    }
    public EmptyDirVolumeSource getEmptyDir(){
    return this.emptyDir!=null?this.emptyDir.build():null;
    }
    public T withEmptyDir( EmptyDirVolumeSource emptyDir){
    if (emptyDir!=null){ this.emptyDir= new EmptyDirVolumeSourceBuilder(emptyDir); _visitables.add(this.emptyDir);} return (T) this;
    }
    public EmptyDirNested<T> withNewEmptyDir(){
    return new EmptyDirNested<T>();
    }
    public EmptyDirNested<T> withNewEmptyDirLike( EmptyDirVolumeSource item){
    return new EmptyDirNested<T>(item);
    }
    public EmptyDirNested<T> editEmptyDir(){
    return withNewEmptyDirLike(getEmptyDir());
    }
    public T withNewEmptyDir( String medium){
    return withEmptyDir(new EmptyDirVolumeSource(medium));
    }
    public GCEPersistentDiskVolumeSource getGcePersistentDisk(){
    return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
    }
    public T withGcePersistentDisk( GCEPersistentDiskVolumeSource gcePersistentDisk){
    if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.add(this.gcePersistentDisk);} return (T) this;
    }
    public GcePersistentDiskNested<T> withNewGcePersistentDisk(){
    return new GcePersistentDiskNested<T>();
    }
    public GcePersistentDiskNested<T> withNewGcePersistentDiskLike( GCEPersistentDiskVolumeSource item){
    return new GcePersistentDiskNested<T>(item);
    }
    public GcePersistentDiskNested<T> editGcePersistentDisk(){
    return withNewGcePersistentDiskLike(getGcePersistentDisk());
    }
    public T withNewGcePersistentDisk( String fsType,  Integer partition,  String pdName,  Boolean readOnly){
    return withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }
    public GitRepoVolumeSource getGitRepo(){
    return this.gitRepo!=null?this.gitRepo.build():null;
    }
    public T withGitRepo( GitRepoVolumeSource gitRepo){
    if (gitRepo!=null){ this.gitRepo= new GitRepoVolumeSourceBuilder(gitRepo); _visitables.add(this.gitRepo);} return (T) this;
    }
    public GitRepoNested<T> withNewGitRepo(){
    return new GitRepoNested<T>();
    }
    public GitRepoNested<T> withNewGitRepoLike( GitRepoVolumeSource item){
    return new GitRepoNested<T>(item);
    }
    public GitRepoNested<T> editGitRepo(){
    return withNewGitRepoLike(getGitRepo());
    }
    public T withNewGitRepo( String repository,  String revision){
    return withGitRepo(new GitRepoVolumeSource(repository, revision));
    }
    public GlusterfsVolumeSource getGlusterfs(){
    return this.glusterfs!=null?this.glusterfs.build():null;
    }
    public T withGlusterfs( GlusterfsVolumeSource glusterfs){
    if (glusterfs!=null){ this.glusterfs= new GlusterfsVolumeSourceBuilder(glusterfs); _visitables.add(this.glusterfs);} return (T) this;
    }
    public GlusterfsNested<T> withNewGlusterfs(){
    return new GlusterfsNested<T>();
    }
    public GlusterfsNested<T> withNewGlusterfsLike( GlusterfsVolumeSource item){
    return new GlusterfsNested<T>(item);
    }
    public GlusterfsNested<T> editGlusterfs(){
    return withNewGlusterfsLike(getGlusterfs());
    }
    public T withNewGlusterfs( String endpoints,  String path,  Boolean readOnly){
    return withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }
    public HostPathVolumeSource getHostPath(){
    return this.hostPath!=null?this.hostPath.build():null;
    }
    public T withHostPath( HostPathVolumeSource hostPath){
    if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.add(this.hostPath);} return (T) this;
    }
    public HostPathNested<T> withNewHostPath(){
    return new HostPathNested<T>();
    }
    public HostPathNested<T> withNewHostPathLike( HostPathVolumeSource item){
    return new HostPathNested<T>(item);
    }
    public HostPathNested<T> editHostPath(){
    return withNewHostPathLike(getHostPath());
    }
    public T withNewHostPath( String path){
    return withHostPath(new HostPathVolumeSource(path));
    }
    public ISCSIVolumeSource getIscsi(){
    return this.iscsi!=null?this.iscsi.build():null;
    }
    public T withIscsi( ISCSIVolumeSource iscsi){
    if (iscsi!=null){ this.iscsi= new ISCSIVolumeSourceBuilder(iscsi); _visitables.add(this.iscsi);} return (T) this;
    }
    public IscsiNested<T> withNewIscsi(){
    return new IscsiNested<T>();
    }
    public IscsiNested<T> withNewIscsiLike( ISCSIVolumeSource item){
    return new IscsiNested<T>(item);
    }
    public IscsiNested<T> editIscsi(){
    return withNewIscsiLike(getIscsi());
    }
    public T withNewIscsi( String fsType,  String iqn,  Integer lun,  Boolean readOnly,  String targetPortal){
    return withIscsi(new ISCSIVolumeSource(fsType, iqn, lun, readOnly, targetPortal));
    }
    public MetadataVolumeSource getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( MetadataVolumeSource metadata){
    if (metadata!=null){ this.metadata= new MetadataVolumeSourceBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( MetadataVolumeSource item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public NFSVolumeSource getNfs(){
    return this.nfs!=null?this.nfs.build():null;
    }
    public T withNfs( NFSVolumeSource nfs){
    if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.add(this.nfs);} return (T) this;
    }
    public NfsNested<T> withNewNfs(){
    return new NfsNested<T>();
    }
    public NfsNested<T> withNewNfsLike( NFSVolumeSource item){
    return new NfsNested<T>(item);
    }
    public NfsNested<T> editNfs(){
    return withNewNfsLike(getNfs());
    }
    public T withNewNfs( String path,  Boolean readOnly,  String server){
    return withNfs(new NFSVolumeSource(path, readOnly, server));
    }
    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim(){
    return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }
    public T withPersistentVolumeClaim( PersistentVolumeClaimVolumeSource persistentVolumeClaim){
    if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new PersistentVolumeClaimVolumeSourceBuilder(persistentVolumeClaim); _visitables.add(this.persistentVolumeClaim);} return (T) this;
    }
    public PersistentVolumeClaimNested<T> withNewPersistentVolumeClaim(){
    return new PersistentVolumeClaimNested<T>();
    }
    public PersistentVolumeClaimNested<T> withNewPersistentVolumeClaimLike( PersistentVolumeClaimVolumeSource item){
    return new PersistentVolumeClaimNested<T>(item);
    }
    public PersistentVolumeClaimNested<T> editPersistentVolumeClaim(){
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
    }
    public T withNewPersistentVolumeClaim( String claimName,  Boolean readOnly){
    return withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
    }
    public RBDVolumeSource getRbd(){
    return this.rbd!=null?this.rbd.build():null;
    }
    public T withRbd( RBDVolumeSource rbd){
    if (rbd!=null){ this.rbd= new RBDVolumeSourceBuilder(rbd); _visitables.add(this.rbd);} return (T) this;
    }
    public RbdNested<T> withNewRbd(){
    return new RbdNested<T>();
    }
    public RbdNested<T> withNewRbdLike( RBDVolumeSource item){
    return new RbdNested<T>(item);
    }
    public RbdNested<T> editRbd(){
    return withNewRbdLike(getRbd());
    }
    public SecretVolumeSource getSecret(){
    return this.secret!=null?this.secret.build():null;
    }
    public T withSecret( SecretVolumeSource secret){
    if (secret!=null){ this.secret= new SecretVolumeSourceBuilder(secret); _visitables.add(this.secret);} return (T) this;
    }
    public SecretNested<T> withNewSecret(){
    return new SecretNested<T>();
    }
    public SecretNested<T> withNewSecretLike( SecretVolumeSource item){
    return new SecretNested<T>(item);
    }
    public SecretNested<T> editSecret(){
    return withNewSecretLike(getSecret());
    }
    public T withNewSecret( String secretName){
    return withSecret(new SecretVolumeSource(secretName));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
VolumeFluent that = (VolumeFluent) o;
if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
if (emptyDir != null ? !emptyDir.equals(that.emptyDir) :that.emptyDir != null) return false;
if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
if (gitRepo != null ? !gitRepo.equals(that.gitRepo) :that.gitRepo != null) return false;
if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class AwsElasticBlockStoreNested<N> extends AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>> implements Nested<N>{

        private final AWSElasticBlockStoreVolumeSourceBuilder builder;
    
             AwsElasticBlockStoreNested (){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }
             AwsElasticBlockStoreNested ( AWSElasticBlockStoreVolumeSource item){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }
    
            public N endAwsElasticBlockStore(){
            return and();
        }
            public N and(){
            return (N) VolumeFluent.this.withAwsElasticBlockStore(builder.build());
        }
    
}
    public class CephfsNested<N> extends CephFSVolumeSourceFluent<CephfsNested<N>> implements Nested<N>{

        private final CephFSVolumeSourceBuilder builder;
    
             CephfsNested ( CephFSVolumeSource item){
        this.builder = new CephFSVolumeSourceBuilder(this, item);
        }
             CephfsNested (){
        this.builder = new CephFSVolumeSourceBuilder(this);
        }
    
            public N endCephfs(){
            return and();
        }
            public N and(){
            return (N) VolumeFluent.this.withCephfs(builder.build());
        }
    
}
    public class EmptyDirNested<N> extends EmptyDirVolumeSourceFluent<EmptyDirNested<N>> implements Nested<N>{

        private final EmptyDirVolumeSourceBuilder builder;
    
             EmptyDirNested (){
        this.builder = new EmptyDirVolumeSourceBuilder(this);
        }
             EmptyDirNested ( EmptyDirVolumeSource item){
        this.builder = new EmptyDirVolumeSourceBuilder(this, item);
        }
    
            public N endEmptyDir(){
            return and();
        }
            public N and(){
            return (N) VolumeFluent.this.withEmptyDir(builder.build());
        }
    
}
    public class GcePersistentDiskNested<N> extends GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>> implements Nested<N>{

        private final GCEPersistentDiskVolumeSourceBuilder builder;
    
             GcePersistentDiskNested (){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }
             GcePersistentDiskNested ( GCEPersistentDiskVolumeSource item){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }
    
            public N endGcePersistentDisk(){
            return and();
        }
            public N and(){
            return (N) VolumeFluent.this.withGcePersistentDisk(builder.build());
        }
    
}
    public class GitRepoNested<N> extends GitRepoVolumeSourceFluent<GitRepoNested<N>> implements Nested<N>{

        private final GitRepoVolumeSourceBuilder builder;
    
             GitRepoNested (){
        this.builder = new GitRepoVolumeSourceBuilder(this);
        }
             GitRepoNested ( GitRepoVolumeSource item){
        this.builder = new GitRepoVolumeSourceBuilder(this, item);
        }
    
            public N endGitRepo(){
            return and();
        }
            public N and(){
            return (N) VolumeFluent.this.withGitRepo(builder.build());
        }
    
}
    public class GlusterfsNested<N> extends GlusterfsVolumeSourceFluent<GlusterfsNested<N>> implements Nested<N>{

        private final GlusterfsVolumeSourceBuilder builder;
    
             GlusterfsNested (){
        this.builder = new GlusterfsVolumeSourceBuilder(this);
        }
             GlusterfsNested ( GlusterfsVolumeSource item){
        this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluent.this.withGlusterfs(builder.build());
        }
            public N endGlusterfs(){
            return and();
        }
    
}
    public class HostPathNested<N> extends HostPathVolumeSourceFluent<HostPathNested<N>> implements Nested<N>{

        private final HostPathVolumeSourceBuilder builder;
    
             HostPathNested ( HostPathVolumeSource item){
        this.builder = new HostPathVolumeSourceBuilder(this, item);
        }
             HostPathNested (){
        this.builder = new HostPathVolumeSourceBuilder(this);
        }
    
            public N and(){
            return (N) VolumeFluent.this.withHostPath(builder.build());
        }
            public N endHostPath(){
            return and();
        }
    
}
    public class IscsiNested<N> extends ISCSIVolumeSourceFluent<IscsiNested<N>> implements Nested<N>{

        private final ISCSIVolumeSourceBuilder builder;
    
             IscsiNested (){
        this.builder = new ISCSIVolumeSourceBuilder(this);
        }
             IscsiNested ( ISCSIVolumeSource item){
        this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluent.this.withIscsi(builder.build());
        }
            public N endIscsi(){
            return and();
        }
    
}
    public class MetadataNested<N> extends MetadataVolumeSourceFluent<MetadataNested<N>> implements Nested<N>{

        private final MetadataVolumeSourceBuilder builder;
    
             MetadataNested (){
        this.builder = new MetadataVolumeSourceBuilder(this);
        }
             MetadataNested ( MetadataVolumeSource item){
        this.builder = new MetadataVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class NfsNested<N> extends NFSVolumeSourceFluent<NfsNested<N>> implements Nested<N>{

        private final NFSVolumeSourceBuilder builder;
    
             NfsNested (){
        this.builder = new NFSVolumeSourceBuilder(this);
        }
             NfsNested ( NFSVolumeSource item){
        this.builder = new NFSVolumeSourceBuilder(this, item);
        }
    
            public N endNfs(){
            return and();
        }
            public N and(){
            return (N) VolumeFluent.this.withNfs(builder.build());
        }
    
}
    public class PersistentVolumeClaimNested<N> extends PersistentVolumeClaimVolumeSourceFluent<PersistentVolumeClaimNested<N>> implements Nested<N>{

        private final PersistentVolumeClaimVolumeSourceBuilder builder;
    
             PersistentVolumeClaimNested (){
        this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this);
        }
             PersistentVolumeClaimNested ( PersistentVolumeClaimVolumeSource item){
        this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
        }
    
            public N endPersistentVolumeClaim(){
            return and();
        }
            public N and(){
            return (N) VolumeFluent.this.withPersistentVolumeClaim(builder.build());
        }
    
}
    public class RbdNested<N> extends RBDVolumeSourceFluent<RbdNested<N>> implements Nested<N>{

        private final RBDVolumeSourceBuilder builder;
    
             RbdNested (){
        this.builder = new RBDVolumeSourceBuilder(this);
        }
             RbdNested ( RBDVolumeSource item){
        this.builder = new RBDVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluent.this.withRbd(builder.build());
        }
            public N endRbd(){
            return and();
        }
    
}
    public class SecretNested<N> extends SecretVolumeSourceFluent<SecretNested<N>> implements Nested<N>{

        private final SecretVolumeSourceBuilder builder;
    
             SecretNested (){
        this.builder = new SecretVolumeSourceBuilder(this);
        }
             SecretNested ( SecretVolumeSource item){
        this.builder = new SecretVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluent.this.withSecret(builder.build());
        }
            public N endSecret(){
            return and();
        }
    
}


}
