package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DeploymentTriggerPolicyFluent<T extends DeploymentTriggerPolicyFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<DeploymentTriggerImageChangeParams, ?> imageChangeParams;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public DeploymentTriggerImageChangeParams getImageChangeParams(){
    return this.imageChangeParams!=null?this.imageChangeParams.build():null;
    }
    public T withImageChangeParams( DeploymentTriggerImageChangeParams imageChangeParams){
    if (imageChangeParams!=null){ this.imageChangeParams= new DeploymentTriggerImageChangeParamsBuilder(imageChangeParams); _visitables.add(this.imageChangeParams);} return (T) this;
    }
    public ImageChangeParamsNested<T> withNewImageChangeParams(){
    return new ImageChangeParamsNested<T>();
    }
    public ImageChangeParamsNested<T> withNewImageChangeParamsLike( DeploymentTriggerImageChangeParams item){
    return new ImageChangeParamsNested<T>(item);
    }
    public ImageChangeParamsNested<T> editImageChangeParams(){
    return withNewImageChangeParamsLike(getImageChangeParams());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentTriggerPolicyFluent that = (DeploymentTriggerPolicyFluent) o;
if (imageChangeParams != null ? !imageChangeParams.equals(that.imageChangeParams) :that.imageChangeParams != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ImageChangeParamsNested<N> extends DeploymentTriggerImageChangeParamsFluent<ImageChangeParamsNested<N>> implements Nested<N>{

        private final DeploymentTriggerImageChangeParamsBuilder builder;
    
             ImageChangeParamsNested (){
        this.builder = new DeploymentTriggerImageChangeParamsBuilder(this);
        }
             ImageChangeParamsNested ( DeploymentTriggerImageChangeParams item){
        this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
        }
    
            public N and(){
            return (N) DeploymentTriggerPolicyFluent.this.withImageChangeParams(builder.build());
        }
            public N endImageChangeParams(){
            return and();
        }
    
}


}
