package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamedAuthInfoFluent<T extends NamedAuthInfoFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String name;     VisitableBuilder<AuthInfo, ?> user;     Map<String, Object> additionalProperties = new HashMap();

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public AuthInfo getUser(){
    return this.user!=null?this.user.build():null;
    }
    public T withUser( AuthInfo user){
    if (user!=null){ this.user= new AuthInfoBuilder(user); _visitables.add(this.user);} return (T) this;
    }
    public UserNested<T> withNewUser(){
    return new UserNested<T>();
    }
    public UserNested<T> withNewUserLike( AuthInfo item){
    return new UserNested<T>(item);
    }
    public UserNested<T> editUser(){
    return withNewUserLike(getUser());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedAuthInfoFluent that = (NamedAuthInfoFluent) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class UserNested<N> extends AuthInfoFluent<UserNested<N>> implements Nested<N>{

        private final AuthInfoBuilder builder;
    
             UserNested (){
        this.builder = new AuthInfoBuilder(this);
        }
             UserNested ( AuthInfo item){
        this.builder = new AuthInfoBuilder(this, item);
        }
    
            public N and(){
            return (N) NamedAuthInfoFluent.this.withUser(builder.build());
        }
            public N endUser(){
            return and();
        }
    
}


}
