
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "containerID",
    "image",
    "imageID",
    "lastState",
    "name",
    "ready",
    "restartCount",
    "state"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class ContainerStatus {

    /**
     * container's ID in the format 'docker://<container_id>'; see http://releases.k8s.io/HEAD/docs/user-guide/container-environment.md#container-information
     * 
     */
    @JsonProperty("containerID")
    private String containerID;
    /**
     * image of the container; see http://releases.k8s.io/HEAD/docs/user-guide/images.md
     * 
     */
    @JsonProperty("image")
    private String image;
    /**
     * ID of the container's image
     * 
     */
    @JsonProperty("imageID")
    private String imageID;
    /**
     * 
     * 
     */
    @JsonProperty("lastState")
    @Valid
    private ContainerState lastState;
    /**
     * name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated
     * 
     */
    @JsonProperty("name")
    @Pattern(regexp = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max = 63)
    private String name;
    /**
     * specifies whether the container has passed its readiness probe
     * 
     */
    @JsonProperty("ready")
    private Boolean ready;
    /**
     * the number of times the container has been restarted
     * 
     */
    @JsonProperty("restartCount")
    private Integer restartCount;
    /**
     * 
     * 
     */
    @JsonProperty("state")
    @Valid
    private ContainerState state;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ContainerStatus() {
    }

    /**
     * 
     * @param imageID
     * @param name
     * @param state
     * @param image
     * @param lastState
     * @param ready
     * @param restartCount
     * @param containerID
     */
    public ContainerStatus(String containerID, String image, String imageID, ContainerState lastState, String name, Boolean ready, Integer restartCount, ContainerState state) {
        this.containerID = containerID;
        this.image = image;
        this.imageID = imageID;
        this.lastState = lastState;
        this.name = name;
        this.ready = ready;
        this.restartCount = restartCount;
        this.state = state;
    }

    /**
     * container's ID in the format 'docker://<container_id>'; see http://releases.k8s.io/HEAD/docs/user-guide/container-environment.md#container-information
     * 
     * @return
     *     The containerID
     */
    @JsonProperty("containerID")
    public String getContainerID() {
        return containerID;
    }

    /**
     * container's ID in the format 'docker://<container_id>'; see http://releases.k8s.io/HEAD/docs/user-guide/container-environment.md#container-information
     * 
     * @param containerID
     *     The containerID
     */
    @JsonProperty("containerID")
    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    /**
     * image of the container; see http://releases.k8s.io/HEAD/docs/user-guide/images.md
     * 
     * @return
     *     The image
     */
    @JsonProperty("image")
    public String getImage() {
        return image;
    }

    /**
     * image of the container; see http://releases.k8s.io/HEAD/docs/user-guide/images.md
     * 
     * @param image
     *     The image
     */
    @JsonProperty("image")
    public void setImage(String image) {
        this.image = image;
    }

    /**
     * ID of the container's image
     * 
     * @return
     *     The imageID
     */
    @JsonProperty("imageID")
    public String getImageID() {
        return imageID;
    }

    /**
     * ID of the container's image
     * 
     * @param imageID
     *     The imageID
     */
    @JsonProperty("imageID")
    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    /**
     * 
     * 
     * @return
     *     The lastState
     */
    @JsonProperty("lastState")
    public ContainerState getLastState() {
        return lastState;
    }

    /**
     * 
     * 
     * @param lastState
     *     The lastState
     */
    @JsonProperty("lastState")
    public void setLastState(ContainerState lastState) {
        this.lastState = lastState;
    }

    /**
     * name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * specifies whether the container has passed its readiness probe
     * 
     * @return
     *     The ready
     */
    @JsonProperty("ready")
    public Boolean getReady() {
        return ready;
    }

    /**
     * specifies whether the container has passed its readiness probe
     * 
     * @param ready
     *     The ready
     */
    @JsonProperty("ready")
    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    /**
     * the number of times the container has been restarted
     * 
     * @return
     *     The restartCount
     */
    @JsonProperty("restartCount")
    public Integer getRestartCount() {
        return restartCount;
    }

    /**
     * the number of times the container has been restarted
     * 
     * @param restartCount
     *     The restartCount
     */
    @JsonProperty("restartCount")
    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    /**
     * 
     * 
     * @return
     *     The state
     */
    @JsonProperty("state")
    public ContainerState getState() {
        return state;
    }

    /**
     * 
     * 
     * @param state
     *     The state
     */
    @JsonProperty("state")
    public void setState(ContainerState state) {
        this.state = state;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
