package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class PersistentVolumeSpecFluent<T extends PersistentVolumeSpecFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     List<String> accessModes = new ArrayList();     VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;     Map<String, Quantity> capacity = new HashMap();     VisitableBuilder<CephFSVolumeSource, ?> cephfs;     VisitableBuilder<ObjectReference, ?> claimRef;     VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;     VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;     VisitableBuilder<HostPathVolumeSource, ?> hostPath;     VisitableBuilder<ISCSIVolumeSource, ?> iscsi;     VisitableBuilder<NFSVolumeSource, ?> nfs;     String persistentVolumeReclaimPolicy;     VisitableBuilder<RBDVolumeSource, ?> rbd;     Map<String, Object> additionalProperties = new HashMap();

    public T addToAccessModes( String ...items){
    for (String item : items) {this.accessModes.add(item);} return (T)this;
    }
    public T removeFromAccessModes( String ...items){
    for (String item : items) {this.accessModes.remove(item);} return (T)this;
    }
    public List<String> getAccessModes(){
    return this.accessModes;
    }
    public T withAccessModes( List<String> accessModes){
    this.accessModes.clear();if (accessModes != null) {for (String item : accessModes){this.addToAccessModes(item);}} return (T) this;
    }
    public T withAccessModes( String ...accessModes){
    this.accessModes.clear(); if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (T) this;
    }
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore(){
    return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
    }
    public T withAwsElasticBlockStore( AWSElasticBlockStoreVolumeSource awsElasticBlockStore){
    if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.add(this.awsElasticBlockStore);} return (T) this;
    }
    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore(){
    return new AwsElasticBlockStoreNested<T>();
    }
    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike( AWSElasticBlockStoreVolumeSource item){
    return new AwsElasticBlockStoreNested<T>(item);
    }
    public AwsElasticBlockStoreNested<T> editAwsElasticBlockStore(){
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
    }
    public T withNewAwsElasticBlockStore( String fsType,  Integer partition,  Boolean readOnly,  String volumeID){
    return withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }
    public T addToCapacity( String key,  Quantity value){
    if(key != null && value != null) {this.capacity.put(key, value);} return (T)this;
    }
    public T removeFromCapacity( String key){
    if(key != null) {this.capacity.remove(key);} return (T)this;
    }
    public Map<String, Quantity> getCapacity(){
    return this.capacity;
    }
    public T withCapacity( Map<String, Quantity> capacity){
    this.capacity.clear();if (capacity != null) {this.capacity.putAll(capacity);} return (T) this;
    }
    public CephFSVolumeSource getCephfs(){
    return this.cephfs!=null?this.cephfs.build():null;
    }
    public T withCephfs( CephFSVolumeSource cephfs){
    if (cephfs!=null){ this.cephfs= new CephFSVolumeSourceBuilder(cephfs); _visitables.add(this.cephfs);} return (T) this;
    }
    public CephfsNested<T> withNewCephfs(){
    return new CephfsNested<T>();
    }
    public CephfsNested<T> withNewCephfsLike( CephFSVolumeSource item){
    return new CephfsNested<T>(item);
    }
    public CephfsNested<T> editCephfs(){
    return withNewCephfsLike(getCephfs());
    }
    public ObjectReference getClaimRef(){
    return this.claimRef!=null?this.claimRef.build():null;
    }
    public T withClaimRef( ObjectReference claimRef){
    if (claimRef!=null){ this.claimRef= new ObjectReferenceBuilder(claimRef); _visitables.add(this.claimRef);} return (T) this;
    }
    public ClaimRefNested<T> withNewClaimRef(){
    return new ClaimRefNested<T>();
    }
    public ClaimRefNested<T> withNewClaimRefLike( ObjectReference item){
    return new ClaimRefNested<T>(item);
    }
    public ClaimRefNested<T> editClaimRef(){
    return withNewClaimRefLike(getClaimRef());
    }
    public GCEPersistentDiskVolumeSource getGcePersistentDisk(){
    return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
    }
    public T withGcePersistentDisk( GCEPersistentDiskVolumeSource gcePersistentDisk){
    if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.add(this.gcePersistentDisk);} return (T) this;
    }
    public GcePersistentDiskNested<T> withNewGcePersistentDisk(){
    return new GcePersistentDiskNested<T>();
    }
    public GcePersistentDiskNested<T> withNewGcePersistentDiskLike( GCEPersistentDiskVolumeSource item){
    return new GcePersistentDiskNested<T>(item);
    }
    public GcePersistentDiskNested<T> editGcePersistentDisk(){
    return withNewGcePersistentDiskLike(getGcePersistentDisk());
    }
    public T withNewGcePersistentDisk( String fsType,  Integer partition,  String pdName,  Boolean readOnly){
    return withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }
    public GlusterfsVolumeSource getGlusterfs(){
    return this.glusterfs!=null?this.glusterfs.build():null;
    }
    public T withGlusterfs( GlusterfsVolumeSource glusterfs){
    if (glusterfs!=null){ this.glusterfs= new GlusterfsVolumeSourceBuilder(glusterfs); _visitables.add(this.glusterfs);} return (T) this;
    }
    public GlusterfsNested<T> withNewGlusterfs(){
    return new GlusterfsNested<T>();
    }
    public GlusterfsNested<T> withNewGlusterfsLike( GlusterfsVolumeSource item){
    return new GlusterfsNested<T>(item);
    }
    public GlusterfsNested<T> editGlusterfs(){
    return withNewGlusterfsLike(getGlusterfs());
    }
    public T withNewGlusterfs( String endpoints,  String path,  Boolean readOnly){
    return withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }
    public HostPathVolumeSource getHostPath(){
    return this.hostPath!=null?this.hostPath.build():null;
    }
    public T withHostPath( HostPathVolumeSource hostPath){
    if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.add(this.hostPath);} return (T) this;
    }
    public HostPathNested<T> withNewHostPath(){
    return new HostPathNested<T>();
    }
    public HostPathNested<T> withNewHostPathLike( HostPathVolumeSource item){
    return new HostPathNested<T>(item);
    }
    public HostPathNested<T> editHostPath(){
    return withNewHostPathLike(getHostPath());
    }
    public T withNewHostPath( String path){
    return withHostPath(new HostPathVolumeSource(path));
    }
    public ISCSIVolumeSource getIscsi(){
    return this.iscsi!=null?this.iscsi.build():null;
    }
    public T withIscsi( ISCSIVolumeSource iscsi){
    if (iscsi!=null){ this.iscsi= new ISCSIVolumeSourceBuilder(iscsi); _visitables.add(this.iscsi);} return (T) this;
    }
    public IscsiNested<T> withNewIscsi(){
    return new IscsiNested<T>();
    }
    public IscsiNested<T> withNewIscsiLike( ISCSIVolumeSource item){
    return new IscsiNested<T>(item);
    }
    public IscsiNested<T> editIscsi(){
    return withNewIscsiLike(getIscsi());
    }
    public T withNewIscsi( String fsType,  String iqn,  Integer lun,  Boolean readOnly,  String targetPortal){
    return withIscsi(new ISCSIVolumeSource(fsType, iqn, lun, readOnly, targetPortal));
    }
    public NFSVolumeSource getNfs(){
    return this.nfs!=null?this.nfs.build():null;
    }
    public T withNfs( NFSVolumeSource nfs){
    if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.add(this.nfs);} return (T) this;
    }
    public NfsNested<T> withNewNfs(){
    return new NfsNested<T>();
    }
    public NfsNested<T> withNewNfsLike( NFSVolumeSource item){
    return new NfsNested<T>(item);
    }
    public NfsNested<T> editNfs(){
    return withNewNfsLike(getNfs());
    }
    public T withNewNfs( String path,  Boolean readOnly,  String server){
    return withNfs(new NFSVolumeSource(path, readOnly, server));
    }
    public String getPersistentVolumeReclaimPolicy(){
    return this.persistentVolumeReclaimPolicy;
    }
    public T withPersistentVolumeReclaimPolicy( String persistentVolumeReclaimPolicy){
    this.persistentVolumeReclaimPolicy=persistentVolumeReclaimPolicy; return (T) this;
    }
    public RBDVolumeSource getRbd(){
    return this.rbd!=null?this.rbd.build():null;
    }
    public T withRbd( RBDVolumeSource rbd){
    if (rbd!=null){ this.rbd= new RBDVolumeSourceBuilder(rbd); _visitables.add(this.rbd);} return (T) this;
    }
    public RbdNested<T> withNewRbd(){
    return new RbdNested<T>();
    }
    public RbdNested<T> withNewRbdLike( RBDVolumeSource item){
    return new RbdNested<T>(item);
    }
    public RbdNested<T> editRbd(){
    return withNewRbdLike(getRbd());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PersistentVolumeSpecFluent that = (PersistentVolumeSpecFluent) o;
if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
if (claimRef != null ? !claimRef.equals(that.claimRef) :that.claimRef != null) return false;
if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
if (persistentVolumeReclaimPolicy != null ? !persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) :that.persistentVolumeReclaimPolicy != null) return false;
if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class AwsElasticBlockStoreNested<N> extends AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>> implements Nested<N>{

        private final AWSElasticBlockStoreVolumeSourceBuilder builder;
    
             AwsElasticBlockStoreNested (){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }
             AwsElasticBlockStoreNested ( AWSElasticBlockStoreVolumeSource item){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }
    
            public N endAwsElasticBlockStore(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluent.this.withAwsElasticBlockStore(builder.build());
        }
    
}
    public class CephfsNested<N> extends CephFSVolumeSourceFluent<CephfsNested<N>> implements Nested<N>{

        private final CephFSVolumeSourceBuilder builder;
    
             CephfsNested (){
        this.builder = new CephFSVolumeSourceBuilder(this);
        }
             CephfsNested ( CephFSVolumeSource item){
        this.builder = new CephFSVolumeSourceBuilder(this, item);
        }
    
            public N endCephfs(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluent.this.withCephfs(builder.build());
        }
    
}
    public class ClaimRefNested<N> extends ObjectReferenceFluent<ClaimRefNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             ClaimRefNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ClaimRefNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endClaimRef(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluent.this.withClaimRef(builder.build());
        }
    
}
    public class GcePersistentDiskNested<N> extends GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>> implements Nested<N>{

        private final GCEPersistentDiskVolumeSourceBuilder builder;
    
             GcePersistentDiskNested (){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }
             GcePersistentDiskNested ( GCEPersistentDiskVolumeSource item){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }
    
            public N endGcePersistentDisk(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluent.this.withGcePersistentDisk(builder.build());
        }
    
}
    public class GlusterfsNested<N> extends GlusterfsVolumeSourceFluent<GlusterfsNested<N>> implements Nested<N>{

        private final GlusterfsVolumeSourceBuilder builder;
    
             GlusterfsNested ( GlusterfsVolumeSource item){
        this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }
             GlusterfsNested (){
        this.builder = new GlusterfsVolumeSourceBuilder(this);
        }
    
            public N endGlusterfs(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluent.this.withGlusterfs(builder.build());
        }
    
}
    public class HostPathNested<N> extends HostPathVolumeSourceFluent<HostPathNested<N>> implements Nested<N>{

        private final HostPathVolumeSourceBuilder builder;
    
             HostPathNested (){
        this.builder = new HostPathVolumeSourceBuilder(this);
        }
             HostPathNested ( HostPathVolumeSource item){
        this.builder = new HostPathVolumeSourceBuilder(this, item);
        }
    
            public N endHostPath(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluent.this.withHostPath(builder.build());
        }
    
}
    public class IscsiNested<N> extends ISCSIVolumeSourceFluent<IscsiNested<N>> implements Nested<N>{

        private final ISCSIVolumeSourceBuilder builder;
    
             IscsiNested (){
        this.builder = new ISCSIVolumeSourceBuilder(this);
        }
             IscsiNested ( ISCSIVolumeSource item){
        this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }
    
            public N endIscsi(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluent.this.withIscsi(builder.build());
        }
    
}
    public class NfsNested<N> extends NFSVolumeSourceFluent<NfsNested<N>> implements Nested<N>{

        private final NFSVolumeSourceBuilder builder;
    
             NfsNested ( NFSVolumeSource item){
        this.builder = new NFSVolumeSourceBuilder(this, item);
        }
             NfsNested (){
        this.builder = new NFSVolumeSourceBuilder(this);
        }
    
            public N endNfs(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluent.this.withNfs(builder.build());
        }
    
}
    public class RbdNested<N> extends RBDVolumeSourceFluent<RbdNested<N>> implements Nested<N>{

        private final RBDVolumeSourceBuilder builder;
    
             RbdNested (){
        this.builder = new RBDVolumeSourceBuilder(this);
        }
             RbdNested ( RBDVolumeSource item){
        this.builder = new RBDVolumeSourceBuilder(this, item);
        }
    
            public N endRbd(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluent.this.withRbd(builder.build());
        }
    
}


}
