/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildSpec;
import io.fabric8.openshift.api.model.BuildSpecBuilder;
import io.fabric8.openshift.api.model.BuildSpecFluent;
import io.fabric8.openshift.api.model.BuildStatus;
import io.fabric8.openshift.api.model.BuildStatusBuilder;
import io.fabric8.openshift.api.model.BuildStatusFluent;
import java.util.HashMap;
import java.util.Map;

public class BuildFluent<T extends BuildFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Build.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<BuildSpec, ?> spec;
    VisitableBuilder<BuildStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Build.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Build.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public BuildSpec getSpec() {
        return this.spec != null ? (BuildSpec)this.spec.build() : null;
    }

    public T withSpec(BuildSpec spec) {
        if (spec != null) {
            this.spec = new BuildSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public SpecNested<T> withNewSpecLike(BuildSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    public BuildStatus getStatus() {
        return this.status != null ? (BuildStatus)this.status.build() : null;
    }

    public T withStatus(BuildStatus status) {
        if (status != null) {
            this.status = new BuildStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public StatusNested<T> withNewStatusLike(BuildStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildFluent that = (BuildFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNested<N>
    extends BuildStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final BuildStatusBuilder builder;

        StatusNested() {
            this.builder = new BuildStatusBuilder(this);
        }

        StatusNested(BuildStatus item) {
            this.builder = new BuildStatusBuilder(this, item);
        }

        public N endStatus() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildFluent.this.withStatus(this.builder.build());
        }
    }

    public class SpecNested<N>
    extends BuildSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final BuildSpecBuilder builder;

        SpecNested(BuildSpec item) {
            this.builder = new BuildSpecBuilder(this, item);
        }

        SpecNested() {
            this.builder = new BuildSpecBuilder(this);
        }

        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildFluent.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildFluent.this.withMetadata(this.builder.build());
        }
    }
}

