/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableProjectStatus;
import io.fabric8.openshift.api.model.ProjectStatus;
import io.fabric8.openshift.api.model.ProjectStatusFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ProjectStatusBuilder
extends ProjectStatusFluent<ProjectStatusBuilder>
implements VisitableBuilder<ProjectStatus, ProjectStatusBuilder> {
    ProjectStatusFluent<?> fluent;

    public ProjectStatusBuilder() {
        this(new ProjectStatus());
    }

    public ProjectStatusBuilder(ProjectStatusFluent<?> fluent) {
        this(fluent, new ProjectStatus());
    }

    public ProjectStatusBuilder(ProjectStatusFluent<?> fluent, ProjectStatus instance) {
        this.fluent = fluent;
        fluent.withPhase(instance.getPhase());
    }

    public ProjectStatusBuilder(ProjectStatus instance) {
        this.fluent = this;
        this.withPhase(instance.getPhase());
    }

    @Override
    public EditableProjectStatus build() {
        EditableProjectStatus buildable = new EditableProjectStatus(this.fluent.getPhase());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectStatusBuilder that = (ProjectStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

