package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface SecurityContextConstraintsFluent<T extends SecurityContextConstraintsFluent<T>> extends Fluent<T>{


    public Boolean isAllowHostDirVolumePlugin();    public T withAllowHostDirVolumePlugin( Boolean allowHostDirVolumePlugin);    public Boolean isAllowHostNetwork();    public T withAllowHostNetwork( Boolean allowHostNetwork);    public Boolean isAllowHostPorts();    public T withAllowHostPorts( Boolean allowHostPorts);    public Boolean isAllowPrivilegedContainer();    public T withAllowPrivilegedContainer( Boolean allowPrivilegedContainer);    public T addToAllowedCapabilities( String ...items);    public T removeFromAllowedCapabilities( String ...items);    public List<String> getAllowedCapabilities();    public T withAllowedCapabilities( List<String> allowedCapabilities);    public T withAllowedCapabilities( String ...allowedCapabilities);    public SecurityContextConstraints.ApiVersion getApiVersion();    public T withApiVersion( SecurityContextConstraints.ApiVersion apiVersion);    public T addToGroups( String ...items);    public T removeFromGroups( String ...items);    public List<String> getGroups();    public T withGroups( List<String> groups);    public T withGroups( String ...groups);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public RunAsUserStrategyOptions getRunAsUser();    public T withRunAsUser( RunAsUserStrategyOptions runAsUser);    public RunAsUserNested<T> withNewRunAsUser();    public RunAsUserNested<T> withNewRunAsUserLike( RunAsUserStrategyOptions item);    public RunAsUserNested<T> editRunAsUser();    public T withNewRunAsUser( String type,  Long uid,  Long uidRangeMax,  Long uidRangeMin);    public SELinuxContextStrategyOptions getSeLinuxContext();    public T withSeLinuxContext( SELinuxContextStrategyOptions seLinuxContext);    public SeLinuxContextNested<T> withNewSeLinuxContext();    public SeLinuxContextNested<T> withNewSeLinuxContextLike( SELinuxContextStrategyOptions item);    public SeLinuxContextNested<T> editSeLinuxContext();    public T addToUsers( String ...items);    public T removeFromUsers( String ...items);    public List<String> getUsers();    public T withUsers( List<String> users);    public T withUsers( String ...users);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface RunAsUserNested<N> extends Nested<N>, RunAsUserStrategyOptionsFluent<RunAsUserNested<N>>{
            public N endRunAsUser();            public N and();        
}

    public interface SeLinuxContextNested<N> extends Nested<N>, SELinuxContextStrategyOptionsFluent<SeLinuxContextNested<N>>{
            public N and();            public N endSeLinuxContext();        
}


}
