package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

public interface BuildSourceFluent<T extends BuildSourceFluent<T>> extends Fluent<T>{


    public String getContextDir();    public T withContextDir( String contextDir);    public GitBuildSource getGit();    public T withGit( GitBuildSource git);    public GitNested<T> withNewGit();    public GitNested<T> withNewGitLike( GitBuildSource item);    public GitNested<T> editGit();    public T withNewGit( String httpProxy,  String httpsProxy,  String ref,  String uri);    public LocalObjectReference getSourceSecret();    public T withSourceSecret( LocalObjectReference sourceSecret);    public SourceSecretNested<T> withNewSourceSecret();    public SourceSecretNested<T> withNewSourceSecretLike( LocalObjectReference item);    public SourceSecretNested<T> editSourceSecret();    public T withNewSourceSecret( String name);    public String getType();    public T withType( String type);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface GitNested<N> extends Nested<N>, GitBuildSourceFluent<GitNested<N>>{
            public N and();            public N endGit();        
}

    public interface SourceSecretNested<N> extends Nested<N>, LocalObjectReferenceFluent<SourceSecretNested<N>>{
            public N and();            public N endSourceSecret();        
}


}
