package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;

public class ExecNewPodHookFluentImpl<T extends ExecNewPodHookFluent<T>> extends BaseFluent<T> implements ExecNewPodHookFluent<T>{

     List<String> command = new ArrayList();     String containerName;     List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public T addToCommand( String ...items){
    for (String item : items) {this.command.add(item);} return (T)this;
    }
    public T removeFromCommand( String ...items){
    for (String item : items) {this.command.remove(item);} return (T)this;
    }
    public List<String> getCommand(){
    return this.command;
    }
    public T withCommand( List<String> command){
    this.command.clear();if (command != null) {for (String item : command){this.addToCommand(item);}} return (T) this;
    }
    public T withCommand( String ...command){
    this.command.clear(); if (command != null) {for (String item :command){ this.addToCommand(item);}} return (T) this;
    }
    public String getContainerName(){
    return this.containerName;
    }
    public T withContainerName( String containerName){
    this.containerName=containerName; return (T) this;
    }
    public T addToEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (T)this;
    }
    public T removeFromEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (T)this;
    }
    public List<EnvVar> getEnv(){
    return build(env);
    }
    public T withEnv( List<EnvVar> env){
    this.env.clear();if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (T) this;
    }
    public T withEnv( EnvVar ...env){
    this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (T) this;
    }
    public EnvNested<T> addNewEnv(){
    return new EnvNestedImpl<T>();
    }
    public EnvNested<T> addNewEnvLike( EnvVar item){
    return new EnvNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ExecNewPodHookFluentImpl that = (ExecNewPodHookFluentImpl) o;
if (command != null ? !command.equals(that.command) :that.command != null) return false;
if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
if (env != null ? !env.equals(that.env) :that.env != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class EnvNestedImpl<N> extends EnvVarFluentImpl<EnvNested<N>> implements EnvNested<N>{

        private final EnvVarBuilder builder;
    
             EnvNestedImpl (){
        this.builder = new EnvVarBuilder(this);
        }
             EnvNestedImpl ( EnvVar item){
        this.builder = new EnvVarBuilder(this, item);
        }
    
            public N endEnv(){
            return and();
        }
            public N and(){
            return (N) ExecNewPodHookFluentImpl.this.addToEnv(builder.build());
        }
    
}


}
