package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface OAuthClientFluent<T extends OAuthClientFluent<T>> extends Fluent<T>{


    public OAuthClient.ApiVersion getApiVersion();    public T withApiVersion( OAuthClient.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToRedirectURIs( String ...items);    public T removeFromRedirectURIs( String ...items);    public List<String> getRedirectURIs();    public T withRedirectURIs( List<String> redirectURIs);    public T withRedirectURIs( String ...redirectURIs);    public Boolean isRespondWithChallenges();    public T withRespondWithChallenges( Boolean respondWithChallenges);    public String getSecret();    public T withSecret( String secret);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
