package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ReplicationControllerListFluent<T extends ReplicationControllerListFluent<T>> extends Fluent<T>{


    public ReplicationControllerList.ApiVersion getApiVersion();    public T withApiVersion( ReplicationControllerList.ApiVersion apiVersion);    public T addToItems( ReplicationController ...items);    public T removeFromItems( ReplicationController ...items);    public List<ReplicationController> getItems();    public T withItems( List<ReplicationController> items);    public T withItems( ReplicationController ...items);    public ItemsNested<T> addNewItem();    public ItemsNested<T> addNewItemLike( ReplicationController item);    public String getKind();    public T withKind( String kind);    public ListMeta getMetadata();    public T withMetadata( ListMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ListMeta item);    public MetadataNested<T> editMetadata();    public T withNewMetadata( String resourceVersion,  String selfLink);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ItemsNested<N> extends Nested<N>, ReplicationControllerFluent<ItemsNested<N>>{
            public N endItem();            public N and();        
}

    public interface MetadataNested<N> extends Nested<N>, ListMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
