package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ResourceQuotaFluent<T extends ResourceQuotaFluent<T>> extends Fluent<T>{


    public ResourceQuota.ApiVersion getApiVersion();    public T withApiVersion( ResourceQuota.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public ResourceQuotaSpec getSpec();    public T withSpec( ResourceQuotaSpec spec);    public SpecNested<T> withNewSpec();    public SpecNested<T> withNewSpecLike( ResourceQuotaSpec item);    public SpecNested<T> editSpec();    public ResourceQuotaStatus getStatus();    public T withStatus( ResourceQuotaStatus status);    public StatusNested<T> withNewStatus();    public StatusNested<T> withNewStatusLike( ResourceQuotaStatus item);    public StatusNested<T> editStatus();    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>, ResourceQuotaSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>, ResourceQuotaStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
