package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ClusterPolicyFluentImpl<T extends ClusterPolicyFluent<T>> extends BaseFluent<T> implements ClusterPolicyFluent<T>{

     ClusterPolicy.ApiVersion apiVersion;     String kind;     String lastModified;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<NamedClusterRole, ?>> roles = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public ClusterPolicy.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ClusterPolicy.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getLastModified(){
    return this.lastModified;
    }
    public T withLastModified( String lastModified){
    this.lastModified=lastModified; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToRoles( NamedClusterRole ...items){
    for (NamedClusterRole item : items) {NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);_visitables.add(builder);this.roles.add(builder);} return (T)this;
    }
    public T removeFromRoles( NamedClusterRole ...items){
    for (NamedClusterRole item : items) {NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);_visitables.remove(builder);this.roles.remove(builder);} return (T)this;
    }
    public List<NamedClusterRole> getRoles(){
    return build(roles);
    }
    public T withRoles( List<NamedClusterRole> roles){
    this.roles.clear();if (roles != null) {for (NamedClusterRole item : roles){this.addToRoles(item);}} return (T) this;
    }
    public T withRoles( NamedClusterRole ...roles){
    this.roles.clear(); if (roles != null) {for (NamedClusterRole item :roles){ this.addToRoles(item);}} return (T) this;
    }
    public RolesNested<T> addNewRole(){
    return new RolesNestedImpl<T>();
    }
    public RolesNested<T> addNewRoleLike( NamedClusterRole item){
    return new RolesNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ClusterPolicyFluentImpl that = (ClusterPolicyFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (lastModified != null ? !lastModified.equals(that.lastModified) :that.lastModified != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (roles != null ? !roles.equals(that.roles) :that.roles != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) ClusterPolicyFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class RolesNestedImpl<N> extends NamedClusterRoleFluentImpl<RolesNested<N>> implements RolesNested<N>{

        private final NamedClusterRoleBuilder builder;
    
             RolesNestedImpl (){
        this.builder = new NamedClusterRoleBuilder(this);
        }
             RolesNestedImpl ( NamedClusterRole item){
        this.builder = new NamedClusterRoleBuilder(this, item);
        }
    
            public N endRole(){
            return and();
        }
            public N and(){
            return (N) ClusterPolicyFluentImpl.this.addToRoles(builder.build());
        }
    
}


}
