/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContextFluent;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContextFluentImpl<T extends ContextFluent<T>>
extends BaseFluent<T>
implements ContextFluent<T> {
    String cluster;
    List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();
    String namespace;
    String user;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public String getCluster() {
        return this.cluster;
    }

    @Override
    public T withCluster(String cluster) {
        this.cluster = cluster;
        return (T)this;
    }

    @Override
    public T addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedExtension> getExtensions() {
        return this.build(this.extensions);
    }

    @Override
    public T withExtensions(List<NamedExtension> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)this;
    }

    @Override
    public ContextFluent.ExtensionsNested<T> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public ContextFluent.ExtensionsNested<T> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(item);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public T withNamespace(String namespace) {
        this.namespace = namespace;
        return (T)this;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public T withUser(String user) {
        this.user = user;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextFluentImpl that = (ContextFluentImpl)o;
        if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<ContextFluent.ExtensionsNested<N>>
    implements ContextFluent.ExtensionsNested<N> {
        private final NamedExtensionBuilder builder;

        ExtensionsNestedImpl(NamedExtension item) {
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNestedImpl() {
            this.builder = new NamedExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContextFluentImpl.this.addToExtensions(this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }
}

