/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableSecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextFluent;
import io.fabric8.kubernetes.api.model.SecurityContextFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SecurityContextBuilder
extends SecurityContextFluentImpl<SecurityContextBuilder>
implements VisitableBuilder<SecurityContext, SecurityContextBuilder> {
    SecurityContextFluent<?> fluent;

    public SecurityContextBuilder() {
        this(new SecurityContext());
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent) {
        this(fluent, new SecurityContext());
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent, SecurityContext instance) {
        this.fluent = fluent;
        fluent.withCapabilities(instance.getCapabilities());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
    }

    public SecurityContextBuilder(SecurityContext instance) {
        this.fluent = this;
        this.withCapabilities(instance.getCapabilities());
        this.withPrivileged(instance.getPrivileged());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
    }

    @Override
    public EditableSecurityContext build() {
        EditableSecurityContext buildable = new EditableSecurityContext(this.fluent.getCapabilities(), this.fluent.isPrivileged(), this.fluent.isRunAsNonRoot(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxOptions());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextBuilder that = (SecurityContextBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

