/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.NamedRole;
import io.fabric8.openshift.api.model.NamedRoleBuilder;
import io.fabric8.openshift.api.model.NamedRoleFluentImpl;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.PolicyFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolicyFluentImpl<T extends PolicyFluent<T>>
extends BaseFluent<T>
implements PolicyFluent<T> {
    Policy.ApiVersion apiVersion;
    String kind;
    String lastModified;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<NamedRole, ?>> roles = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public Policy.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(Policy.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public T withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public PolicyFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PolicyFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PolicyFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T addToRoles(NamedRole ... items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.add(builder);
            this.roles.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromRoles(NamedRole ... items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.remove(builder);
            this.roles.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedRole> getRoles() {
        return this.build(this.roles);
    }

    @Override
    public T withRoles(List<NamedRole> roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withRoles(NamedRole ... roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (T)this;
    }

    @Override
    public PolicyFluent.RolesNested<T> addNewRole() {
        return new RolesNestedImpl();
    }

    @Override
    public PolicyFluent.RolesNested<T> addNewRoleLike(NamedRole item) {
        return new RolesNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyFluentImpl that = (PolicyFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RolesNestedImpl<N>
    extends NamedRoleFluentImpl<PolicyFluent.RolesNested<N>>
    implements PolicyFluent.RolesNested<N> {
        private final NamedRoleBuilder builder;

        RolesNestedImpl() {
            this.builder = new NamedRoleBuilder(this);
        }

        RolesNestedImpl(NamedRole item) {
            this.builder = new NamedRoleBuilder(this, item);
        }

        @Override
        public N endRole() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PolicyFluentImpl.this.addToRoles(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PolicyFluent.MetadataNested<N>>
    implements PolicyFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

