package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class EventFluent<T extends EventFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Event.ApiVersion apiVersion;     Integer count;     String firstTimestamp;     VisitableBuilder<ObjectReference, ?> involvedObject;     String kind;     String lastTimestamp;     String message;     VisitableBuilder<ObjectMeta, ?> metadata;     String reason;     EventSource source;     Map<String, Object> additionalProperties = new HashMap();

    public Event.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Event.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public Integer getCount(){
    return this.count;
    }
    public T withCount( Integer count){
    this.count=count; return (T) this;
    }
    public String getFirstTimestamp(){
    return this.firstTimestamp;
    }
    public T withFirstTimestamp( String firstTimestamp){
    this.firstTimestamp=firstTimestamp; return (T) this;
    }
    public ObjectReference getInvolvedObject(){
    return this.involvedObject!=null?this.involvedObject.build():null;
    }
    public T withInvolvedObject( ObjectReference involvedObject){
    if (involvedObject!=null){ this.involvedObject= new ObjectReferenceBuilder(involvedObject); _visitables.add(this.involvedObject);} return (T) this;
    }
    public InvolvedObjectNested<T> withNewInvolvedObject(){
    return new InvolvedObjectNested<T>();
    }
    public InvolvedObjectNested<T> withNewInvolvedObjectLike( ObjectReference item){
    return new InvolvedObjectNested<T>(item);
    }
    public InvolvedObjectNested<T> editInvolvedObject(){
    return withNewInvolvedObjectLike(getInvolvedObject());
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getLastTimestamp(){
    return this.lastTimestamp;
    }
    public T withLastTimestamp( String lastTimestamp){
    this.lastTimestamp=lastTimestamp; return (T) this;
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getReason(){
    return this.reason;
    }
    public T withReason( String reason){
    this.reason=reason; return (T) this;
    }
    public EventSource getSource(){
    return this.source;
    }
    public T withSource( EventSource source){
    this.source=source; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class InvolvedObjectNested<N> extends ObjectReferenceFluent<InvolvedObjectNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             InvolvedObjectNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             InvolvedObjectNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endInvolvedObject(){
            return and();
        }
            public N and(){
            return (N) EventFluent.this.withInvolvedObject(builder.build());
        }
    
}
    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) EventFluent.this.withMetadata(builder.build());
        }
    
}


}
