package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class HandlerFluentImpl<T extends HandlerFluent<T>> extends BaseFluent<T> implements HandlerFluent<T>{

     VisitableBuilder<ExecAction, ?> exec;     VisitableBuilder<HTTPGetAction, ?> httpGet;     VisitableBuilder<TCPSocketAction, ?> tcpSocket;     Map<String, Object> additionalProperties = new HashMap();

    public ExecAction getExec(){
    return this.exec!=null?this.exec.build():null;
    }
    public T withExec( ExecAction exec){
    if (exec!=null){ this.exec= new ExecActionBuilder(exec); _visitables.add(this.exec);} return (T) this;
    }
    public ExecNested<T> withNewExec(){
    return new ExecNestedImpl<T>();
    }
    public ExecNested<T> withNewExecLike( ExecAction item){
    return new ExecNestedImpl<T>(item);
    }
    public ExecNested<T> editExec(){
    return withNewExecLike(getExec());
    }
    public HTTPGetAction getHttpGet(){
    return this.httpGet!=null?this.httpGet.build():null;
    }
    public T withHttpGet( HTTPGetAction httpGet){
    if (httpGet!=null){ this.httpGet= new HTTPGetActionBuilder(httpGet); _visitables.add(this.httpGet);} return (T) this;
    }
    public HttpGetNested<T> withNewHttpGet(){
    return new HttpGetNestedImpl<T>();
    }
    public HttpGetNested<T> withNewHttpGetLike( HTTPGetAction item){
    return new HttpGetNestedImpl<T>(item);
    }
    public HttpGetNested<T> editHttpGet(){
    return withNewHttpGetLike(getHttpGet());
    }
    public TCPSocketAction getTcpSocket(){
    return this.tcpSocket!=null?this.tcpSocket.build():null;
    }
    public T withTcpSocket( TCPSocketAction tcpSocket){
    if (tcpSocket!=null){ this.tcpSocket= new TCPSocketActionBuilder(tcpSocket); _visitables.add(this.tcpSocket);} return (T) this;
    }
    public TcpSocketNested<T> withNewTcpSocket(){
    return new TcpSocketNestedImpl<T>();
    }
    public TcpSocketNested<T> withNewTcpSocketLike( TCPSocketAction item){
    return new TcpSocketNestedImpl<T>(item);
    }
    public TcpSocketNested<T> editTcpSocket(){
    return withNewTcpSocketLike(getTcpSocket());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HandlerFluentImpl that = (HandlerFluentImpl) o;
if (exec != null ? !exec.equals(that.exec) :that.exec != null) return false;
if (httpGet != null ? !httpGet.equals(that.httpGet) :that.httpGet != null) return false;
if (tcpSocket != null ? !tcpSocket.equals(that.tcpSocket) :that.tcpSocket != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ExecNestedImpl<N> extends ExecActionFluentImpl<ExecNested<N>> implements ExecNested<N>{

        private final ExecActionBuilder builder;
    
             ExecNestedImpl (){
        this.builder = new ExecActionBuilder(this);
        }
             ExecNestedImpl ( ExecAction item){
        this.builder = new ExecActionBuilder(this, item);
        }
    
            public N and(){
            return (N) HandlerFluentImpl.this.withExec(builder.build());
        }
            public N endExec(){
            return and();
        }
    
}
    public class HttpGetNestedImpl<N> extends HTTPGetActionFluentImpl<HttpGetNested<N>> implements HttpGetNested<N>{

        private final HTTPGetActionBuilder builder;
    
             HttpGetNestedImpl (){
        this.builder = new HTTPGetActionBuilder(this);
        }
             HttpGetNestedImpl ( HTTPGetAction item){
        this.builder = new HTTPGetActionBuilder(this, item);
        }
    
            public N endHttpGet(){
            return and();
        }
            public N and(){
            return (N) HandlerFluentImpl.this.withHttpGet(builder.build());
        }
    
}
    public class TcpSocketNestedImpl<N> extends TCPSocketActionFluentImpl<TcpSocketNested<N>> implements TcpSocketNested<N>{

        private final TCPSocketActionBuilder builder;
    
             TcpSocketNestedImpl (){
        this.builder = new TCPSocketActionBuilder(this);
        }
             TcpSocketNestedImpl ( TCPSocketAction item){
        this.builder = new TCPSocketActionBuilder(this, item);
        }
    
            public N and(){
            return (N) HandlerFluentImpl.this.withTcpSocket(builder.build());
        }
            public N endTcpSocket(){
            return and();
        }
    
}


}
